/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class ArcFurnaceRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object slag;
    public final int slagCount;
    public final Object[] output;
    public final int time;
    public final int energy;

    public ArcFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object[] output, int time, int energy) {
        this(key, input, ItemStack.f_41583_, 0, output, time, energy);
    }

    public ArcFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object slag, int slagCount, Object[] output, int time, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.slag = slag;
        this.slagCount = slagCount;
        this.output = output;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        IngredientWithSize ing = null;
        ArrayList<IngredientWithSize> additives = new ArrayList<IngredientWithSize>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient is;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                count = (Integer)this.input[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(in)) == EmptyIngredient.INSTANCE) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            if (ing == null) {
                ing = new IngredientWithSize(is, count.intValue());
                continue;
            }
            additives.add(new IngredientWithSize(is, count.intValue()));
        }
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.input));
        }
        IngredientWithSize slagIng = new IngredientWithSize(MiscHelper.INSTANCE.getIngredient(this.slag), this.slagCount);
        ArrayList<IngredientWithSize> outputs = new ArrayList<IngredientWithSize>();
        ArrayList<Pair> secondary = new ArrayList<Pair>();
        i = 0;
        while (i < this.output.length) {
            Ingredient ingredient;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Object chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((ingredient = MiscHelper.INSTANCE.getIngredient(out)) == EmptyIngredient.INSTANCE) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            if (((Float)chance).floatValue() == 1.0f) {
                outputs.add(new IngredientWithSize(ingredient, count.intValue()));
                continue;
            }
            secondary.add(Pair.of((Object)new IngredientWithSize(ingredient, count.intValue()), (Object)chance));
        }
        if (outputs.isEmpty() && secondary.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "immersiveengineering:arc_furnace");
        json.add("input", ing.serialize());
        JsonArray addJson = new JsonArray();
        for (IngredientWithSize ingredientWithSize : additives) {
            addJson.add(ingredientWithSize.serialize());
        }
        json.add("additives", (JsonElement)addJson);
        JsonArray resultJson = new JsonArray();
        for (IngredientWithSize outIng : outputs) {
            resultJson.add(outIng.serialize());
        }
        json.add("results", (JsonElement)resultJson);
        JsonArray jsonArray = new JsonArray();
        for (Pair pair : secondary) {
            JsonObject outputJson = new JsonObject();
            outputJson.add("output", ((IngredientWithSize)pair.getLeft()).serialize());
            outputJson.addProperty("chance", (Number)pair.getRight());
            jsonArray.add((JsonElement)outputJson);
        }
        json.add("secondaries", (JsonElement)jsonArray);
        if (!slagIng.hasNoMatchingItems()) {
            json.add("slag", slagIng.serialize());
        }
        json.addProperty("time", (Number)this.time);
        json.addProperty("energy", (Number)this.energy);
        return json;
    }
}

