/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.electrodynamics.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class ChemicalCrystallizerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final double experience;
    public final int time;
    public final double energy;

    public ChemicalCrystallizerRecipeSerializer(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double experience, int time, double energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.experience = experience;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        JsonObject ingJson;
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "electrodynamics:chemical_crystallizer_recipe");
        JsonObject fluidInputJson = new JsonObject();
        fluidInputJson.addProperty("count", (Number)1);
        if (this.input instanceof String || this.input instanceof ResourceLocation) {
            ingJson = new JsonObject();
            ingJson.addProperty("tag", this.input.toString());
            ingJson.addProperty("amount", (Number)this.inputAmount);
        } else {
            FluidStack ing = MiscHelper.INSTANCE.getFluidStack(this.input, this.inputAmount);
            if (ing.isEmpty()) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
            }
            ingJson = MiscHelper.INSTANCE.serializeFluidStack(ing);
        }
        fluidInputJson.add("0", (JsonElement)ingJson);
        json.add("fluidinputs", (JsonElement)fluidInputJson);
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("experience", (Number)this.experience);
        json.addProperty("ticks", (Number)this.time);
        json.addProperty("usagepertick", (Number)this.energy);
        return json;
    }
}

