/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.actuallyadditions;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.actuallyadditions.ActuallyAdditionsHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"actuallyadditions"})
public class ActuallyAdditionsNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("black_quartz", "coal", "diamond", "emerald", "lapis", "redstone"));

    @Override
    public String getName() {
        return "actuallyadditions_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ActuallyAdditionsHelper helper = ActuallyAdditionsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            if (material.hasExtra(1)) {
                ResourceLocation extraLocation;
                IMaterial extraMaterial = material.getExtra(1);
                if (!itemTags.contains(extraLocation = miscHelper.getTagLocation(switch (extraMaterial.getType()) {
                    case MaterialType.INGOT -> "raw_materials";
                    case MaterialType.INGOT_LEGACY -> "dusts";
                    default -> extraMaterial.getType().getFormName();
                }, extraMaterial.getName()))) continue;
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "actuallyadditions.ore_to_material." + material.getName()), oreLocation, materialLocation, material.getType() != MaterialType.DUST ? 2 : 5, 1.0f, extraLocation, 1, 0.2f);
                continue;
            }
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "actuallyadditions.ore_to_material." + material.getName()), oreLocation, materialLocation, material.getType() != MaterialType.DUST ? 2 : 5, 1.0f);
        }
    }
}

