/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.fluids;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import thelm.jaopca.api.fluids.PlaceableFluid;

public abstract class PlaceableFluidBlock
extends Block
implements BucketPickup {
    protected final StateDefinition<Block, BlockState> stateDefinition;
    protected final PlaceableFluid fluid;
    protected final int maxLevel;
    protected final IntegerProperty levelProperty;

    public PlaceableFluidBlock(BlockBehaviour.Properties properties, PlaceableFluid fluid, int maxLevel) {
        super(properties);
        this.fluid = fluid;
        this.maxLevel = maxLevel;
        this.levelProperty = IntegerProperty.m_61631_((String)"level", (int)0, (int)maxLevel);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.m_7926_((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateDefinition = builder.m_61101_(Block::m_49966_, BlockState::new);
        this.m_49959_((BlockState)((BlockState)this.stateDefinition.m_61090_()).m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(maxLevel)));
    }

    public IntegerProperty getLevelProperty() {
        return this.levelProperty;
    }

    public boolean m_6724_(BlockState blockState) {
        return blockState.m_60819_().m_76187_();
    }

    public void m_213898_(BlockState blockState, ServerLevel world, BlockPos pos, RandomSource random) {
        world.m_6425_(pos).m_230562_((Level)world, pos, random);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter world, BlockPos pos, PathComputationType type) {
        return !this.fluid.m_205067_(FluidTags.f_13132_);
    }

    public FluidState m_5888_(BlockState blockState) {
        IntegerProperty fluidLevelProperty = this.fluid.getLevelProperty();
        int blockLevel = (Integer)blockState.m_61143_((Property)this.levelProperty);
        int fluidLevel = blockLevel >= this.maxLevel ? this.maxLevel + 1 : this.maxLevel - blockLevel;
        return (FluidState)this.fluid.m_76145_().m_61124_((Property)fluidLevelProperty, (Comparable)Integer.valueOf(fluidLevel));
    }

    public boolean m_6104_(BlockState blockState, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.m_60819_().m_76152_().m_6212_((Fluid)this.fluid);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return List.of();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_6807_(BlockState blockState, Level world, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (!FluidInteractionRegistry.canInteract((Level)world, (BlockPos)pos)) {
            world.m_186469_(pos, blockState.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)world));
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (blockState.m_60819_().m_76170_() || facingState.m_60819_().m_76170_()) {
            world.m_186469_(currentPos, blockState.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)world));
        }
        return super.m_7417_(blockState, facing, facingState, world, currentPos, facingPos);
    }

    public void m_6861_(BlockState blockState, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!FluidInteractionRegistry.canInteract((Level)world, (BlockPos)pos)) {
            world.m_186469_(pos, blockState.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)world));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.levelProperty != null) {
            builder.m_61104_(new Property[]{this.levelProperty});
        }
    }

    public StateDefinition<Block, BlockState> m_49965_() {
        return this.stateDefinition;
    }

    public ItemStack m_142598_(LevelAccessor world, BlockPos pos, BlockState blockState) {
        if ((Integer)blockState.m_61143_((Property)this.levelProperty) == 0) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
            return new ItemStack((ItemLike)this.fluid.m_6859_());
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return this.fluid.m_142520_();
    }
}

