/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader;

import com.hlysine.create_power_loader.CPLBlockEntityTypes;
import com.hlysine.create_power_loader.CPLBlocks;
import com.hlysine.create_power_loader.CPLCommands;
import com.hlysine.create_power_loader.CPLCreativeTabs;
import com.hlysine.create_power_loader.CPLDatagen;
import com.hlysine.create_power_loader.CPLRecipes;
import com.hlysine.create_power_loader.CPLTags;
import com.hlysine.create_power_loader.CreatePowerLoaderClient;
import com.hlysine.create_power_loader.compat.Mods;
import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="create_power_loader")
public class CreatePowerLoader {
    public static final String MODID = "create_power_loader";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static IEventBus modEventBus;
    private static final CreateRegistrate REGISTRATE;

    public CreatePowerLoader() {
        modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        modEventBus.addListener(this::commonSetup);
        forgeEventBus.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRATE.setCreativeTab(CPLCreativeTabs.MAIN);
        CPLTags.register();
        CPLBlocks.register();
        CPLBlockEntityTypes.register();
        CPLCreativeTabs.register(modEventBus);
        CPLConfigs.register(ModLoadingContext.get());
        modEventBus.addListener(EventPriority.LOWEST, CPLDatagen::gatherData);
        forgeEventBus.addListener(ChunkLoadManager::onServerWorldTick);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreatePowerLoaderClient.onCtorClient(modEventBus, forgeEventBus));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Mods.JEI.executeIfInstalled(() -> CPLRecipes::register);
            ForgeChunkManager.setForcedChunkLoadingCallback((String)MODID, ChunkLoadManager::validateAllForcedChunks);
        });
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CPLCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static CreateRegistrate getRegistrate() {
        return REGISTRATE;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MODID, path);
    }

    static {
        REGISTRATE = CreateRegistrate.create((String)MODID);
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

