/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.api.util.CacheContainer;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.content.logistics.board.LogicalMode;
import net.liukrast.eg.content.logistics.board.ScrollOptionPanelBehaviour;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LogicPanelBehaviour
extends ScrollOptionPanelBehaviour<LogicalMode>
implements CacheContainer<Boolean> {
    private int updated = 0;
    private final Map<BlockPos, Boolean> cache = new HashMap<BlockPos, Boolean>();

    public LogicPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.logic_gate"), type, be, slot, LogicalMode.class);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(EGPanelConnections.REDSTONE, () -> !this.redstonePowered ? 15 : 0);
        builder.put((PanelConnection)EGPanelConnections.STRING.get(), () -> this.getDisplayLinkComponent(false).getString());
        builder.put((PanelConnection)EGPanelConnections.INTEGER.get(), () -> !this.redstonePowered ? 15 : 0);
    }

    @Override
    public Item getItem() {
        return (Item)EGItems.LOGIC_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.LOGIC_PANEL;
    }

    @Override
    public Map<BlockPos, Boolean> cacheMap() {
        return this.cache;
    }

    @Override
    public Codec<Boolean> cacheCodec() {
        return Codec.BOOL;
    }

    public void tick() {
        super.tick();
        this.updated = 0;
    }

    public void checkForRedstoneInput() {
        if (!this.active || this.updated > (Integer)ExtraGaugesConfig.LOGIC_MAX_CHAIN.get()) {
            return;
        }
        ArrayList powerList = new ArrayList();
        this.consumeForLinks(link -> powerList.add(link.shouldPanelBePowered()));
        this.consumeForExtra((PanelConnection)EGPanelConnections.REDSTONE.get(), (pos, out) -> {
            this.cache.put((BlockPos)pos, out > 0);
            powerList.add(out > 0);
        });
        this.consumeForPanels((PanelConnection)EGPanelConnections.REDSTONE.get(), out -> powerList.add(out > 0));
        this.sendCache(this);
        boolean shouldPower = ((LogicalMode)((Object)this.get())).test(powerList.stream());
        if (shouldPower != this.redstonePowered) {
            return;
        }
        this.redstonePowered = !shouldPower;
        this.blockEntity.notifyUpdate();
        ++this.updated;
        for (FactoryPanelPosition panelPos : this.targeting) {
            if (!this.getWorld().m_46749_(panelPos.pos())) {
                return;
            }
            FactoryPanelBehaviour behaviour = FactoryPanelBehaviour.at((BlockAndTintGetter)this.getWorld(), (FactoryPanelPosition)panelPos);
            if (behaviour == null) continue;
            behaviour.checkForRedstoneInput();
        }
        this.notifyRedstoneOutputs();
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        return EGPanelConnections.getConnectionValue(other, EGPanelConnections.REDSTONE).map(v -> v == 0 ? 5767425 : 0xEF0000).orElse(super.calculatePath(other, original));
    }

    @Override
    public int calculateExtraPath(BlockPos pos) {
        Level level = this.getWorld();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        ConnectionExtra listener = ((PanelConnection)EGPanelConnections.REDSTONE.get()).getListener(state.m_60734_());
        if (listener == null) {
            return super.calculateExtraPath(pos);
        }
        return listener.invalidate(level, state, pos, be).map(v -> {
            boolean k = v == 0;
            Boolean cache = this.cache.get(pos);
            if (((Boolean)ExtraGaugesConfig.PANEL_CACHING.get()).booleanValue() && cache != null && k == cache) {
                return 16766273;
            }
            return k ? 5767425 : 0xEF0000;
        }).orElse(super.calculateExtraPath(pos));
    }

    @Override
    public boolean shouldRenderBulb(boolean original) {
        return true;
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        boolean active = this.getConnectionValue(EGPanelConnections.REDSTONE).orElse(0) > 0;
        Object t = "\u2714";
        Object f = "\u2716";
        if (!shortened) {
            t = (String)t + " True";
            f = (String)f + " False";
        }
        return Component.m_237113_((String)(active ? t : f));
    }
}

