/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.foundation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.lang.LangNumberFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TFLang {
    public static String asId(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static String nonPluralId(String name) {
        String asId = TFLang.asId(name);
        return asId.endsWith("s") ? asId.substring(0, asId.length() - 1) : asId;
    }

    public static List<Component> translatedOptions(String prefix, String ... keys) {
        ArrayList<Component> result = new ArrayList<Component>(keys.length);
        for (String key : keys) {
            result.add((Component)TFLang.translate((String)(prefix != null ? prefix + "." : "") + key, new Object[0]).component());
        }
        return result;
    }

    public static LangBuilder builder() {
        return new LangBuilder("trading_floor");
    }

    public static LangBuilder builder(String namespace) {
        return new LangBuilder(namespace);
    }

    public static LangBuilder blockName(BlockState state) {
        return TFLang.builder().add(state.m_60734_().m_49954_());
    }

    public static LangBuilder itemName(ItemStack stack) {
        return TFLang.builder().add(stack.m_41786_().m_6881_());
    }

    public static LangBuilder itemStack(ItemStack stack) {
        return TFLang.builder().add(stack.m_41786_().m_6881_().m_130940_(ChatFormatting.GRAY)).add(TFLang.text(" x" + stack.m_41613_()).style(ChatFormatting.GREEN));
    }

    public static LangBuilder number(double d) {
        return TFLang.builder().text(LangNumberFormat.format((double)d));
    }

    public static LangBuilder translate(String langKey, Object ... args) {
        return TFLang.builder().translate(langKey, args);
    }

    public static LangBuilder text(String text) {
        return TFLang.builder().text(text);
    }

    public static Object[] resolveBuilders(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof LangBuilder)) continue;
            LangBuilder cb = (LangBuilder)object;
            args[i] = cb.component();
        }
        return args;
    }
}

