/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import in.northwestw.fissionrecipe.recipe.GasCoolantRecipe;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class GasCoolantRecipeSerializer
implements RecipeSerializer<GasCoolantRecipe> {
    public GasCoolantRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)input);
        GasStack output = SerializerHelper.getGasStack((JsonObject)json, (String)"output");
        double thermalEnthalpy = json.get("thermalEnthalpy").getAsDouble();
        double conductivity = json.get("conductivity").getAsDouble();
        return new GasCoolantRecipe(recipeId, inputIngredient, output, thermalEnthalpy, conductivity);
    }

    @Nullable
    public GasCoolantRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            GasStack output = GasStack.readFromPacket((FriendlyByteBuf)buffer);
            double thermalEnthalpy = buffer.readDouble();
            double conductivity = buffer.readDouble();
            return new GasCoolantRecipe(recipeId, inputIngredient, output, thermalEnthalpy, conductivity);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading Gas Coolant Recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, GasCoolantRecipe recipe) {
        try {
            recipe.write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing Gas Coolant Recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

