/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import in.northwestw.fissionrecipe.recipe.FluidCoolantRecipe;
import javax.annotation.Nullable;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class FluidCoolantRecipeSerializer
implements RecipeSerializer<FluidCoolantRecipe> {
    public FluidCoolantRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        FluidStackIngredient inputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)input);
        GasStack output = SerializerHelper.getGasStack((JsonObject)json, (String)"output");
        double thermalEnthalpy = json.get("thermalEnthalpy").getAsDouble();
        double conductivity = json.get("conductivity").getAsDouble();
        double efficiency = json.get("efficiency").getAsDouble();
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Fluid Coolant Recipe output must not be empty.");
        }
        return new FluidCoolantRecipe(recipeId, inputIngredient, output, thermalEnthalpy, conductivity, efficiency);
    }

    @Nullable
    public FluidCoolantRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            FluidStackIngredient inputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            GasStack output = GasStack.readFromPacket((FriendlyByteBuf)buffer);
            double thermalEnthalpy = buffer.readDouble();
            double conductivity = buffer.readDouble();
            double efficiency = buffer.readDouble();
            return new FluidCoolantRecipe(recipeId, inputIngredient, output, thermalEnthalpy, conductivity, efficiency);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading Fluid Coolant Recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, FluidCoolantRecipe recipe) {
        try {
            recipe.write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing Fluid Coolant Recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

