/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import in.northwestw.fissionrecipe.misc.Heat;
import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import javax.annotation.Nullable;
import javax.script.ScriptException;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class FissionRecipeSerializer
implements RecipeSerializer<FissionRecipe> {
    public FissionRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)input);
        GasStack output = SerializerHelper.getGasStack((JsonObject)json, (String)"output");
        JsonElement heatObj = json.get("heat");
        boolean isEqt = false;
        float heat = 0.0f;
        String heatEqt = null;
        try {
            heat = heatObj.getAsFloat();
        }
        catch (ClassCastException ignored) {
            heatEqt = heatObj.getAsString();
            try {
                Heat.JS_ENGINE.eval(heatEqt.replaceAll("x", "0"));
            }
            catch (ScriptException e) {
                throw new JsonSyntaxException("Fission Recipe heat equation is not valid.");
            }
            isEqt = true;
        }
        if (output.isEmpty()) {
            throw new JsonSyntaxException("Fission Recipe output must not be empty.");
        }
        return new FissionRecipe(recipeId, inputIngredient, output, new Heat(isEqt, heat, heatEqt));
    }

    @Nullable
    public FissionRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            GasStack output = GasStack.readFromPacket((FriendlyByteBuf)buffer);
            boolean isEqt = buffer.readBoolean();
            Heat heat = new Heat(isEqt, isEqt ? 0.0 : buffer.readDouble(), isEqt ? buffer.m_130277_() : null);
            return new FissionRecipe(recipeId, inputIngredient, output, heat);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading Fission Recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer, FissionRecipe recipe) {
        try {
            recipe.write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing Fission Recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

