/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.mixin;

import in.northwestw.fissionrecipe.mixin.MixinGuiMekanismTile;
import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import java.util.Collections;
import java.util.List;
import mekanism.api.text.EnumColor;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBigLight;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiHybridGauge;
import mekanism.client.gui.element.graph.GuiDoubleGraph;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.client.gui.GuiFissionReactor;
import mekanism.generators.client.gui.element.GuiFissionReactorTab;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import mekanism.generators.common.network.to_server.PacketGeneratorsGuiInteract;
import mekanism.generators.common.tile.fission.TileEntityFissionReactorCasing;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiFissionReactor.class}, remap=false)
public abstract class MixinGuiFissionReactor
extends MixinGuiMekanismTile<TileEntityFissionReactorCasing, MekanismTileContainer<TileEntityFissionReactorCasing>> {
    @Shadow
    private TranslationButton activateButton;
    @Shadow
    private TranslationButton scramButton;
    @Shadow
    private GuiDoubleGraph heatGraph;

    @Shadow
    protected abstract void updateButtons();

    @Inject(at={@At(value="INVOKE", target="Lmekanism/generators/client/gui/GuiFissionReactor;addRenderableWidget(Lmekanism/client/gui/element/GuiElement;)Lmekanism/client/gui/element/GuiElement;", ordinal=0)}, method={"addGuiElements"}, cancellable=true)
    public void addGuiElements(CallbackInfo ci) {
        ci.cancel();
        this.addRenderableWidget(new GuiFissionReactorTab((IGuiWrapper)((GuiFissionReactor)this), (TileEntityFissionReactorCasing)this.tile, GuiFissionReactorTab.FissionReactorTab.STAT));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)((GuiFissionReactor)this), 45, 17, 105, 56, () -> {
            FissionReactorMultiblockData multiblock = (FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.STATUS.translate(new Object[]{multiblock.isActive() ? EnumColor.BRIGHT_GREEN : EnumColor.RED, BooleanStateDisplay.ActiveDisabled.of((boolean)multiblock.isActive())}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{multiblock.lastBurnRate}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{TextUtils.format((long)multiblock.lastBoilRate)}), MekanismLang.TEMPERATURE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getTempColor(), MekanismUtils.getTemperatureDisplay((double)multiblock.heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{((TileEntityFissionReactorCasing)this.tile).getDamageColor(), ((TileEntityFissionReactorCasing)this.tile).getDamageString()}));
        }).spacing(2).jeiCategories(new MekanismJEIRecipeType[]{FissionRecipe.RECIPE_TYPE}));
        this.addRenderableWidget(new GuiHybridGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).gasCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fluidCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, (IGuiWrapper)((GuiFissionReactor)this), 6, 13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.addRenderableWidget(new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).fuelTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)((GuiFissionReactor)this), 25, 13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.addRenderableWidget(new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).heatedCoolantTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)((GuiFissionReactor)this), 152, 13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE, new Object[0])));
        this.addRenderableWidget(new GuiGasGauge(() -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).wasteTank, () -> ((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).getGasTanks(null), GaugeType.STANDARD, (IGuiWrapper)((GuiFissionReactor)this), 171, 13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
        this.addRenderableWidget(new GuiHeatTab((IGuiWrapper)((GuiFissionReactor)this), () -> {
            Component environment = MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock()).lastEnvironmentLoss, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(new Object[]{environment}));
        }));
        final TileEntityFissionReactorCasing tileCopy = (TileEntityFissionReactorCasing)this.tile;
        this.activateButton = this.addRenderableWidget(new TranslationButton((IGuiWrapper)((GuiFissionReactor)this), 6, 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_ACTIVATE, () -> MekanismGenerators.packetHandler().sendToServer((Object)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)this.tile, 1.0)), (GuiElement.IHoverable)null, () -> EnumColor.DARK_GREEN));
        this.scramButton = this.addRenderableWidget(new TranslationButton((IGuiWrapper)((GuiFissionReactor)this), 89, 75, 81, 16, (ILangEntry)GeneratorsLang.FISSION_SCRAM, () -> MekanismGenerators.packetHandler().sendToServer((Object)new PacketGeneratorsGuiInteract(PacketGeneratorsGuiInteract.GeneratorsGuiInteraction.FISSION_ACTIVE, (BlockEntity)this.tile, 0.0)), null, () -> EnumColor.DARK_RED));
        this.addRenderableWidget(new GuiBigLight((IGuiWrapper)((GuiFissionReactor)this), 173, 76, () -> ((FissionReactorMultiblockData)((FissionReactorMultiblockData)((TileEntityFissionReactorCasing)this.tile).getMultiblock())).isActive()));
        this.addRenderableWidget(new GuiDynamicHorizontalRateBar((IGuiWrapper)((GuiFissionReactor)this), new GuiBar.IBarInfoHandler(){

            public Component getTooltip() {
                return MekanismUtils.getTemperatureDisplay((double)((FissionReactorMultiblockData)tileCopy.getMultiblock()).heatCapacitor.getTemperature(), (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true);
            }

            public double getLevel() {
                return Math.min(1.0, ((FissionReactorMultiblockData)tileCopy.getMultiblock()).heatCapacitor.getTemperature() / 1800.0);
            }
        }, 5, 102, this.f_97726_ - 12));
        this.heatGraph = this.addRenderableWidget(new GuiDoubleGraph((IGuiWrapper)((GuiFissionReactor)this), 5, 123, this.f_97726_ - 10, 38, temp -> MekanismUtils.getTemperatureDisplay((double)temp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)));
        this.heatGraph.setMinScale(1600.0);
        this.updateButtons();
    }
}

