/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.mixin;

import com.google.common.collect.Lists;
import in.northwestw.fissionrecipe.MekanismFission;
import in.northwestw.fissionrecipe.jei.FissionReactorRecipeCategory;
import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import in.northwestw.fissionrecipe.recipe.FluidCoolantRecipe;
import in.northwestw.fissionrecipe.recipe.GasCoolantRecipe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.RecipeRegistryHelper;
import mekanism.generators.client.jei.GeneratorsJEI;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GeneratorsJEI.class}, remap=false)
public class MixinGeneratorsJEI {
    @Overwrite
    public void registerRecipes(IRecipeRegistration registry) {
        ArrayList completedRecipes = Lists.newArrayList();
        List<FissionRecipe> recipes = MixinGeneratorsJEI.getFissionRecipes();
        for (FluidCoolantRecipe fluidCoolantRecipe : FissionReactorRecipeCategory.getFluidCoolants()) {
            completedRecipes.addAll(recipes.stream().map(r -> new FissionReactorRecipeCategory.FissionJEIRecipe((FissionRecipe)((Object)r), fluidCoolantRecipe.getOutputRepresentation(), fluidCoolantRecipe.getInput().getRepresentations())).toList());
        }
        for (GasCoolantRecipe gasCoolantRecipe : FissionReactorRecipeCategory.getGasCoolants()) {
            completedRecipes.addAll(recipes.stream().map(r -> new FissionReactorRecipeCategory.FissionJEIRecipe((FissionRecipe)((Object)r), ((ChemicalStackIngredient.GasStackIngredient)gasCoolantRecipe.getInput()).getRepresentations(), gasCoolantRecipe.getOutputRepresentation())).toList());
        }
        RecipeRegistryHelper.register((IRecipeRegistration)registry, FissionRecipe.RECIPE_TYPE, (List)completedRecipes);
    }

    @Overwrite
    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new FissionReactorRecipeCategory(guiHelper)});
    }

    @Overwrite
    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, FissionRecipe.RECIPE_TYPE, (IItemProvider[])new IItemProvider[]{GeneratorsBlocks.FISSION_REACTOR_CASING, GeneratorsBlocks.FISSION_REACTOR_PORT, GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER, GeneratorsBlocks.FISSION_FUEL_ASSEMBLY, GeneratorsBlocks.CONTROL_ROD_ASSEMBLY});
    }

    @Unique
    private static List<FissionRecipe> getFissionRecipes() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            return ServerLifecycleHooks.getCurrentServer().m_129894_().m_44013_(MekanismFission.Recipes.FISSION.getType());
        }
        return (List)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeCallable & Serializable)() -> Minecraft.m_91087_().m_91403_().m_105141_().m_44013_(MekanismFission.Recipes.FISSION.getType()));
    }
}

