/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.mixin;

import in.northwestw.fissionrecipe.MekanismFission;
import in.northwestw.fissionrecipe.mixin.MixinMultiblockData;
import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import in.northwestw.fissionrecipe.recipe.FluidCoolantRecipe;
import in.northwestw.fissionrecipe.recipe.GasCoolantRecipe;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Coord4D;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.math.FloatingLong;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.capabilities.chemical.multiblock.MultiblockChemicalTankBuilder;
import mekanism.common.capabilities.fluid.VariableCapacityFluidTank;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.content.fission.FissionReactorMultiblockData;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={FissionReactorMultiblockData.class}, remap=false)
public abstract class MixinFissionReactorMultiblockData
extends MixinMultiblockData {
    private Optional<FissionRecipe> fissionRecipe = Optional.empty();
    private Optional<FluidCoolantRecipe> fluidCoolantRecipe = Optional.empty();
    private Optional<GasCoolantRecipe> gasCoolantRecipe = Optional.empty();
    @Shadow
    public IGasTank fuelTank;
    @Shadow
    private int fuelAssemblies;
    @Shadow
    public double burnRemaining;
    @Shadow
    public double rateLimit;
    @Shadow
    public VariableHeatCapacitor heatCapacitor;
    @Shadow
    public double partialWaste;
    @Shadow
    public IGasTank wasteTank;
    @Shadow
    public double lastBurnRate;
    @Shadow
    public VariableCapacityFluidTank fluidCoolantTank;
    @Shadow
    public IGasTank heatedCoolantTank;
    @Shadow
    public IGasTank gasCoolantTank;
    @Shadow
    public long lastBoilRate;

    @Shadow
    public abstract double getBoilEfficiency();

    @Shadow
    protected abstract long clampCoolantHeated(double var1, long var3);

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/capabilities/fluid/VariableCapacityFluidTank;input(Lmekanism/common/lib/multiblock/MultiblockData;Ljava/util/function/IntSupplier;Ljava/util/function/Predicate;Lmekanism/api/IContentsListener;)Lmekanism/common/capabilities/fluid/VariableCapacityFluidTank;", ordinal=0), method={"<init>"})
    public VariableCapacityFluidTank customFluidCoolantTank(MultiblockData multiblock, IntSupplier capacity, Predicate<@NotNull FluidStack> validator, @Nullable IContentsListener listener) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return VariableCapacityFluidTank.input((MultiblockData)multiblock, (IntSupplier)capacity, validator, (IContentsListener)listener);
        }
        List<FluidCoolantRecipe> recipes = MixinFissionReactorMultiblockData.serverFluidCoolantRecipes(server);
        return VariableCapacityFluidTank.input((MultiblockData)multiblock, (IntSupplier)capacity, fluid -> recipes.stream().anyMatch(recipe -> recipe.getInput().testType(fluid)) && this.gasCoolantTank.isEmpty(), (IContentsListener)listener);
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/capabilities/chemical/multiblock/MultiblockChemicalTankBuilder;input(Lmekanism/common/lib/multiblock/MultiblockData;Ljava/util/function/LongSupplier;Ljava/util/function/Predicate;Lmekanism/api/IContentsListener;)Lmekanism/api/chemical/IChemicalTank;", ordinal=0), method={"<init>"})
    public <TANK extends IChemicalTank<Gas, GasStack>> TANK customGasCoolantTank(MultiblockChemicalTankBuilder<Gas, GasStack, IGasTank> instance, MultiblockData multiblock, LongSupplier capacity, Predicate<Gas> validator, @Nullable IContentsListener listener) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return (TANK)instance.input(multiblock, capacity, validator, listener);
        }
        List<GasCoolantRecipe> recipes = MixinFissionReactorMultiblockData.serverGasCoolantRecipes(server);
        return (TANK)instance.input(multiblock, capacity, gas -> recipes.stream().anyMatch(recipe -> ((ChemicalStackIngredient.GasStackIngredient)recipe.getInput()).testType((Chemical)gas)) && this.fluidCoolantTank.isEmpty(), listener);
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/capabilities/chemical/multiblock/MultiblockChemicalTankBuilder;output(Lmekanism/common/lib/multiblock/MultiblockData;Ljava/util/function/LongSupplier;Ljava/util/function/Predicate;Lmekanism/api/IContentsListener;)Lmekanism/api/chemical/IChemicalTank;", ordinal=0), method={"<init>"})
    public <TANK extends IChemicalTank<Gas, GasStack>> TANK customHeatedCoolantTank(MultiblockChemicalTankBuilder<Gas, GasStack, IGasTank> instance, MultiblockData multiblock, LongSupplier capacity, Predicate<Gas> validator, @Nullable IContentsListener listener) {
        return (TANK)instance.output(multiblock, capacity, gas -> true, listener);
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/capabilities/chemical/multiblock/MultiblockChemicalTankBuilder;input(Lmekanism/common/lib/multiblock/MultiblockData;Ljava/util/function/LongSupplier;Ljava/util/function/Predicate;Lmekanism/api/chemical/attribute/ChemicalAttributeValidator;Lmekanism/api/IContentsListener;)Lmekanism/api/chemical/IChemicalTank;", ordinal=0), method={"<init>"})
    public <TANK extends IChemicalTank<Gas, GasStack>> TANK customFuelTank(MultiblockChemicalTankBuilder<Gas, GasStack, IGasTank> instance, MultiblockData multiblock, LongSupplier capacity, Predicate<Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return (TANK)instance.input(multiblock, capacity, validator, attributeValidator, listener);
        }
        List<FissionRecipe> recipes = MixinFissionReactorMultiblockData.serverFissionRecipes(server);
        return (TANK)instance.input(multiblock, capacity, gas -> recipes.stream().anyMatch(recipe -> ((ChemicalStackIngredient.GasStackIngredient)recipe.getInput()).testType((Chemical)gas)), ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/capabilities/chemical/multiblock/MultiblockChemicalTankBuilder;output(Lmekanism/common/lib/multiblock/MultiblockData;Ljava/util/function/LongSupplier;Ljava/util/function/Predicate;Lmekanism/api/chemical/attribute/ChemicalAttributeValidator;Lmekanism/api/IContentsListener;)Lmekanism/api/chemical/IChemicalTank;", ordinal=0), method={"<init>"})
    public <TANK extends IChemicalTank<Gas, GasStack>> TANK customWasteTank(MultiblockChemicalTankBuilder<Gas, GasStack, IGasTank> instance, MultiblockData multiblock, LongSupplier capacity, Predicate<Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IContentsListener listener) {
        return (TANK)instance.output(multiblock, capacity, gas -> true, ChemicalAttributeValidator.ALWAYS_ALLOW, listener);
    }

    @Overwrite
    private void handleCoolant() {
        double temp = this.heatCapacitor.getTemperature();
        double heat = this.getBoilEfficiency() * (temp - HeatUtils.BASE_BOIL_TEMP) * this.heatCapacitor.getHeatCapacity();
        if (!this.fluidCoolantTank.isEmpty()) {
            Optional<FluidCoolantRecipe> recipe;
            if (!this.fluidCoolantRecipe.isPresent()) {
                this.fluidCoolantRecipe = MixinFissionReactorMultiblockData.serverFluidCoolantRecipes(this.getWorld().m_7654_()).stream().filter(r -> r.getInput().testType((Object)this.fluidCoolantTank.getFluid())).findFirst();
            }
            if (!(recipe = this.fluidCoolantRecipe).isPresent()) {
                return;
            }
            double caseCoolantHeat = heat * recipe.get().getConductivity();
            this.lastBoilRate = this.clampCoolantHeated(recipe.get().getEfficiency() / recipe.get().getThermalEnthalpy() * caseCoolantHeat, this.fluidCoolantTank.getFluidAmount());
            if (this.lastBoilRate > 0L) {
                MekanismUtils.logMismatchedStackSize((long)this.fluidCoolantTank.shrinkStack((int)this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                this.heatedCoolantTank.insert((ChemicalStack)((Gas)recipe.get().getOutputRepresentation().getType()).getStack(this.lastBoilRate * recipe.get().getOutputRepresentation().getAmount() / (long)((FluidStack)recipe.get().getInput().getRepresentations().get(0)).getAmount()), Action.EXECUTE, AutomationType.INTERNAL);
                caseCoolantHeat = (double)this.lastBoilRate * recipe.get().getThermalEnthalpy() / recipe.get().getEfficiency();
                this.heatCapacitor.handleHeat(-caseCoolantHeat);
            }
        } else if (!this.gasCoolantTank.isEmpty()) {
            Optional<GasCoolantRecipe> recipe;
            if (!this.gasCoolantRecipe.isPresent()) {
                this.gasCoolantRecipe = MixinFissionReactorMultiblockData.serverGasCoolantRecipes(this.getWorld().m_7654_()).stream().filter(r -> ((ChemicalStackIngredient.GasStackIngredient)r.getInput()).testType((Object)((GasStack)this.gasCoolantTank.getStack()))).findFirst();
            }
            if (!(recipe = this.gasCoolantRecipe).isPresent()) {
                return;
            }
            if (((ChemicalStackIngredient.GasStackIngredient)recipe.get().getInput()).test((Object)((GasStack)this.gasCoolantTank.getStack()))) {
                double caseCoolantHeat = heat * recipe.get().getConductivity();
                this.lastBoilRate = this.clampCoolantHeated(caseCoolantHeat / recipe.get().getThermalEnthalpy(), this.gasCoolantTank.getStored());
                if (this.lastBoilRate > 0L) {
                    MekanismUtils.logMismatchedStackSize((long)this.gasCoolantTank.shrinkStack(this.lastBoilRate, Action.EXECUTE), (long)this.lastBoilRate);
                    GasStack output = recipe.get().getOutputRepresentation();
                    output.setAmount(this.lastBoilRate * recipe.get().getOutputRepresentation().getAmount() / ((GasStack)((ChemicalStackIngredient.GasStackIngredient)recipe.get().getInput()).getRepresentations().get(0)).getAmount());
                    this.heatedCoolantTank.insert((ChemicalStack)output, Action.EXECUTE, AutomationType.INTERNAL);
                    caseCoolantHeat = (double)this.lastBoilRate * recipe.get().getThermalEnthalpy();
                    this.heatCapacitor.handleHeat(-caseCoolantHeat);
                }
            }
        }
    }

    @Overwrite
    private void burnFuel(Level world) {
        Optional<FissionRecipe> recipe;
        if (!this.fissionRecipe.isPresent()) {
            this.fissionRecipe = MixinFissionReactorMultiblockData.serverFissionRecipes(this.getWorld().m_7654_()).stream().filter(r -> ((ChemicalStackIngredient.GasStackIngredient)r.getInput()).testType((Chemical)((Gas)this.fuelTank.getType()))).findFirst();
        }
        if (!(recipe = this.fissionRecipe).isPresent()) {
            return;
        }
        if (!this.wasteTank.isEmpty() && !this.wasteTank.isTypeEqual((Chemical)((Gas)recipe.get().getOutputRepresentation().getType()))) {
            return;
        }
        double lastPartialWaste = this.partialWaste;
        double lastBurnRemaining = this.burnRemaining;
        double storedFuel = (double)this.fuelTank.getStored() + this.burnRemaining;
        double toBurn = Math.min(Math.min(this.rateLimit, storedFuel), (double)((long)this.fuelAssemblies * MekanismGeneratorsConfig.generators.burnPerAssembly.get()));
        this.fuelTank.setStackSize((long)(storedFuel -= toBurn), Action.EXECUTE);
        this.burnRemaining = storedFuel % 1.0;
        this.heatCapacitor.handleHeat(((FloatingLong)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get()).doubleValue() * recipe.get().getHeat(toBurn));
        this.partialWaste += toBurn * (double)recipe.get().getOutputRepresentation().getAmount();
        long newWaste = (long)Math.floor(this.partialWaste) * recipe.get().getOutputRepresentation().getAmount() / ((GasStack)((ChemicalStackIngredient.GasStackIngredient)recipe.get().getInput()).getRepresentations().get(0)).getAmount();
        if (newWaste > 0L) {
            this.partialWaste %= 1.0;
            long leftoverWaste = Math.max(0L, newWaste - this.wasteTank.getNeeded());
            GasStack wasteToAdd = recipe.get().getOutputRepresentation();
            wasteToAdd.setAmount(newWaste);
            this.wasteTank.insert((ChemicalStack)wasteToAdd, Action.EXECUTE, AutomationType.INTERNAL);
            if (leftoverWaste > 0L && IRadiationManager.INSTANCE.isRadiationEnabled()) {
                wasteToAdd.ifAttributePresent(GasAttributes.Radiation.class, attribute -> IRadiationManager.INSTANCE.radiate(new Coord4D((Vec3i)this.getBounds().getCenter(), world), (double)leftoverWaste * attribute.getRadioactivity()));
            }
        }
        this.lastBurnRate = toBurn;
        if (lastPartialWaste != this.partialWaste || lastBurnRemaining != this.burnRemaining) {
            this.markDirty();
        }
    }

    @Unique
    private static List<FissionRecipe> serverFissionRecipes(MinecraftServer server) {
        return server.m_129894_().m_44013_(MekanismFission.Recipes.FISSION.getType());
    }

    @Unique
    private static List<FluidCoolantRecipe> serverFluidCoolantRecipes(MinecraftServer server) {
        return server.m_129894_().m_44013_(MekanismFission.Recipes.FLUID_COOLANT.getType());
    }

    @Unique
    private static List<GasCoolantRecipe> serverGasCoolantRecipes(MinecraftServer server) {
        return server.m_129894_().m_44013_(MekanismFission.Recipes.GAS_COOLANT.getType());
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/util/NBTUtils;setGasStackIfPresent(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Ljava/util/function/Consumer;)V", ordinal=0), method={"readUpdateTag"})
    public void setFuelTankGasStack(CompoundTag nbt, String key, Consumer<GasStack> setter) {
        NBTUtils.setGasStackIfPresent((CompoundTag)nbt, (String)key, value -> this.fuelTank.setStackUnchecked((ChemicalStack)value));
    }

    @Redirect(at=@At(value="INVOKE", target="Lmekanism/common/util/NBTUtils;setGasStackIfPresent(Lnet/minecraft/nbt/CompoundTag;Ljava/lang/String;Ljava/util/function/Consumer;)V", ordinal=2), method={"readUpdateTag"})
    public void setWasteTankGasStack(CompoundTag nbt, String key, Consumer<GasStack> setter) {
        NBTUtils.setGasStackIfPresent((CompoundTag)nbt, (String)key, value -> this.wasteTank.setStackUnchecked((ChemicalStack)value));
    }
}

