/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe.jei;

import in.northwestw.fissionrecipe.MekanismFission;
import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import in.northwestw.fissionrecipe.recipe.FluidCoolantRecipe;
import in.northwestw.fissionrecipe.recipe.GasCoolantRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.common.GeneratorsLang;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.compress.utils.Lists;

public class FissionReactorRecipeCategory
extends BaseRecipeCategory<FissionJEIRecipe> {
    private static final ResourceLocation iconRL = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"radioactive.png");
    private final GuiGauge<?> coolantTank;
    private final GuiGauge<?> fuelTank;
    private final GuiGauge<?> heatedCoolantTank;
    private final GuiGauge<?> wasteTank;

    public FissionReactorRecipeCategory(IGuiHelper helper) {
        super(helper, FissionRecipe.RECIPE_TYPE, (Component)GeneratorsLang.FISSION_REACTOR.translate(new Object[0]), FissionReactorRecipeCategory.createIcon((IGuiHelper)helper, (ResourceLocation)iconRL), 6, 13, 182, 60);
        this.addElement((GuiTexturedElement)new GuiInnerScreen((IGuiWrapper)this, 45, 17, 105, 56, () -> Arrays.asList(MekanismLang.STATUS.translate(new Object[]{EnumColor.BRIGHT_GREEN, BooleanStateDisplay.ActiveDisabled.of((boolean)true)}), GeneratorsLang.GAS_BURN_RATE.translate(new Object[]{1.0}), GeneratorsLang.FISSION_HEATING_RATE.translate(new Object[]{0}), MekanismLang.TEMPERATURE.translate(new Object[]{EnumColor.BRIGHT_GREEN, MekanismUtils.getTemperatureDisplay((double)300.0, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)true)}), GeneratorsLang.FISSION_DAMAGE.translate(new Object[]{EnumColor.BRIGHT_GREEN, TextUtils.getPercent((double)0.0)}))).spacing(2));
        this.coolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiFluidGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)6, (int)13).setLabel((Component)GeneratorsLang.FISSION_COOLANT_TANK.translateColored(EnumColor.AQUA, new Object[0])));
        this.fuelTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)25, (int)13).setLabel((Component)GeneratorsLang.FISSION_FUEL_TANK.translateColored(EnumColor.DARK_GREEN, new Object[0])));
        this.heatedCoolantTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)152, (int)13).setLabel((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translateColored(EnumColor.GRAY, new Object[0])));
        this.wasteTank = (GuiGauge)this.addElement((GuiTexturedElement)GuiGasGauge.getDummy((GaugeType)GaugeType.STANDARD, (IGuiWrapper)this, (int)171, (int)13).setLabel((Component)GeneratorsLang.FISSION_WASTE_TANK.translateColored(EnumColor.BROWN, new Object[0])));
    }

    public static List<FluidCoolantRecipe> getFluidCoolants() {
        return Minecraft.m_91087_().m_91403_().m_105141_().m_44013_(MekanismFission.Recipes.FLUID_COOLANT.getType());
    }

    public static List<GasCoolantRecipe> getGasCoolants() {
        return Minecraft.m_91087_().m_91403_().m_105141_().m_44013_(MekanismFission.Recipes.GAS_COOLANT.getType());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FissionJEIRecipe recipe, IFocusGroup focuses) {
        if (recipe.isFluidCoolant()) {
            this.initFluid(builder, RecipeIngredientRole.INPUT, this.coolantTank, recipe.getFluidInputs());
        } else {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.coolantTank, recipe.getGasInputs());
        }
        GasStack output = recipe.getOutput();
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, (GuiElement)this.fuelTank, ((ChemicalStackIngredient.GasStackIngredient)recipe.getInput()).getRepresentations());
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.heatedCoolantTank, Collections.singletonList(output));
        this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, (GuiElement)this.wasteTank, Collections.singletonList(recipe.getOutputRepresentation()));
    }

    public static class FissionJEIRecipe
    extends FissionRecipe {
        private final boolean fluidCoolant;
        private final List<FluidStack> fluidInputs;
        private final List<GasStack> gasInputs;
        private final GasStack output;

        public FissionJEIRecipe(FissionRecipe recipe, GasStack output, List<FluidStack> inputs) {
            super(recipe.m_6423_(), (ChemicalStackIngredient.GasStackIngredient)recipe.getInput(), recipe.getOutputRepresentation(), recipe.getHeatObject());
            this.fluidCoolant = true;
            this.fluidInputs = inputs;
            this.gasInputs = null;
            this.output = output;
        }

        public FissionJEIRecipe(FissionRecipe recipe, List<GasStack> inputs, GasStack output) {
            super(recipe.m_6423_(), (ChemicalStackIngredient.GasStackIngredient)recipe.getInput(), recipe.getOutputRepresentation(), recipe.getHeatObject());
            this.fluidCoolant = false;
            this.fluidInputs = null;
            this.gasInputs = inputs;
            this.output = output;
        }

        public boolean isFluidCoolant() {
            return this.fluidCoolant;
        }

        public List<FluidStack> getFluidInputs() {
            ArrayList copy = Lists.newArrayList();
            this.fluidInputs.forEach(stack -> {
                if (stack.getAmount() < 0) {
                    FluidStack stackCopy = stack;
                    stackCopy.setAmount(0);
                    copy.add(stackCopy);
                } else {
                    copy.add(stack);
                }
            });
            return copy;
        }

        public List<GasStack> getGasInputs() {
            return this.gasInputs;
        }

        public GasStack getOutput() {
            return this.output;
        }
    }
}

