/*
 * Decompiled with CFR 0.152.
 */
package in.northwestw.fissionrecipe;

import in.northwestw.fissionrecipe.recipe.FissionRecipe;
import in.northwestw.fissionrecipe.recipe.FluidCoolantRecipe;
import in.northwestw.fissionrecipe.recipe.GasCoolantRecipe;
import in.northwestw.fissionrecipe.recipe.serializer.FissionRecipeSerializer;
import in.northwestw.fissionrecipe.recipe.serializer.FluidCoolantRecipeSerializer;
import in.northwestw.fissionrecipe.recipe.serializer.GasCoolantRecipeSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fissionrecipe")
public class MekanismFission {
    public static final String MOD_ID = "fissionrecipe";
    public static final Logger LOGGER = LogManager.getLogger();

    public MekanismFission() {
        Recipes.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static class Recipes<S extends RecipeSerializer<?>> {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"mekanism");
        private static final DeferredRegister<RecipeType<?>> TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"mekanism");
        public static final Recipes<FissionRecipeSerializer> FISSION = new Recipes(SERIALIZERS.register(FissionRecipe.location(), FissionRecipeSerializer::new));
        public static final Recipes<FluidCoolantRecipeSerializer> FLUID_COOLANT = new Recipes(SERIALIZERS.register(FluidCoolantRecipe.location(), FluidCoolantRecipeSerializer::new));
        public static final Recipes<GasCoolantRecipeSerializer> GAS_COOLANT = new Recipes(SERIALIZERS.register(GasCoolantRecipe.location(), GasCoolantRecipeSerializer::new));
        RegistryObject<RecipeType<Recipe<?>>> type;
        RegistryObject<S> serializer;

        private static <T extends Recipe<?>> RegistryObject<RecipeType<T>> customType(final ResourceLocation rl) {
            return TYPES.register(rl.m_135815_(), () -> new RecipeType<T>(){

                public String toString() {
                    return rl.toString();
                }
            });
        }

        private Recipes(RegistryObject<S> serializer) {
            this.serializer = serializer;
            this.type = Recipes.customType(serializer.getId());
        }

        public S getSerializer() {
            return (S)((RecipeSerializer)this.serializer.get());
        }

        public <T extends RecipeType<?>> T getType() {
            return (T)((RecipeType)this.type.get());
        }

        public static void register(IEventBus bus) {
            SERIALIZERS.register(bus);
            TYPES.register(bus);
        }
    }
}

