/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.jei;

import com.oierbravo.createsifter.CreateSifter;
import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.compat.jei.category.SiftingCategory;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.foundation.util.ModLang;
import com.oierbravo.createsifter.register.ModBlocks;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.simibubi.create.infrastructure.config.CRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@ParametersAreNonnullByDefault
@JeiPlugin
public class CreateSifterJEI
implements IModPlugin {
    private static final ResourceLocation ID = CreateSifter.asResource("jei_plugin");
    public IIngredientManager ingredientManager;
    private final List<CreateRecipeCategory<?>> modCategories = new ArrayList();

    private void loadCategories() {
        this.modCategories.clear();
        CreateRecipeCategory<SiftingRecipe> sifting = this.builder(SiftingRecipe.class).addTypedRecipes(ModRecipeTypes.SIFTING).catalyst(() -> ModBlocks.SIFTER.get()).catalyst(() -> ModBlocks.BRASS_SIFTER.get()).doubleItemIcon((ItemLike)ModBlocks.SIFTER.get(), (ItemLike)Blocks.f_49994_).emptyBackground(177, 85).build("sifting", (CreateRecipeCategory.Factory<SiftingRecipe>)((CreateRecipeCategory.Factory)SiftingCategory::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.modCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.modCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.modCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Minecraft.m_91087_().m_91403_().m_105141_().m_44051_().forEach(consumer);
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<CRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<CRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<CRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((CRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateSifterJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateSifterJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)excluded.get()));
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List excludedRecipes = CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CreateJEI.doInputsMatch((Recipe)recipe, (Recipe)excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(AllConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : () -> Collections.emptyList();
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(CreateSifter.asResource(name), this.recipeClass), (Component)ModLang.translate("recipe." + name, new Object[0]).component(), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            CreateSifterJEI.this.modCategories.add(category);
            return category;
        }
    }
}

