/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.lib.Tooltips;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.cucumber.util.WateringCanUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class BaseWateringCanItem
extends BaseItem {
    protected final int range;
    protected final double chance;

    public BaseWateringCanItem(int range, double chance) {
        super(p -> p.m_41487_(1));
        this.range = range;
        this.chance = chance;
    }

    public int m_8105_(ItemStack stack) {
        return 200;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        FluidState fluid;
        ItemStack stack = player.m_21120_(hand);
        if (NBTHelper.getBoolean(stack, "Water")) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockHitResult trace = BaseWateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.m_6662_() != HitResult.Type.BLOCK) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.m_82425_();
        Direction direction = trace.m_82434_();
        if (level.m_7966_(player, pos) && player.m_36204_(pos.m_121945_(direction), direction, stack) && (fluid = level.m_6425_(pos)).m_205070_(FluidTags.f_13131_)) {
            NBTHelper.setBoolean(stack, "Water", true);
            player.m_5496_(SoundEvents.f_11781_, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Direction direction;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        BlockPos pos = context.m_8083_();
        if (!player.m_36204_(pos.m_121945_(direction = context.m_43719_()), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!NBTHelper.getBoolean(stack, "Water")) {
            return InteractionResult.PASS;
        }
        player.m_6672_(hand);
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof FakePlayer) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            Direction direction = context.m_43719_();
            return this.doWater(stack, level, player, pos, direction);
        }
        return InteractionResult.PASS;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingTicks) {
        if (remainingTicks >= 0 && entity instanceof Player) {
            Player player = (Player)entity;
            BlockHitResult trace = BaseWateringCanItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (trace.m_6662_() == HitResult.Type.BLOCK) {
                this.doWater(stack, level, player, trace.m_82425_(), trace.m_82434_());
            } else {
                entity.m_21253_();
            }
        } else {
            entity.m_21253_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag advanced) {
        if (NBTHelper.getBoolean(stack, "Water")) {
            tooltip.add((Component)Tooltips.FILLED.build());
        } else {
            tooltip.add((Component)Tooltips.EMPTY.build());
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(ItemRenderProperties.INSTANCE);
    }

    protected InteractionResult doWater(ItemStack stack, Level level, Player player, BlockPos pos, Direction direction) {
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!player.m_36204_(pos.m_121945_(direction), direction, stack)) {
            return InteractionResult.FAIL;
        }
        if (!NBTHelper.getBoolean(stack, "Water")) {
            return InteractionResult.FAIL;
        }
        if (!this.allowFakePlayerWatering() && player instanceof FakePlayer) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_()) {
            Item item;
            ItemCooldowns cooldowns = player.m_36335_();
            if (!cooldowns.m_41519_(item = stack.m_41720_())) {
                cooldowns.m_41524_(item, BaseWateringCanItem.getThrottleTicks(player));
            } else {
                return InteractionResult.FAIL;
            }
        }
        int range = (this.range - 1) / 2;
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(aoePos -> {
            int moisture;
            BlockState aoeState = level.m_8055_(aoePos);
            if (aoeState.m_60734_() instanceof FarmBlock && (moisture = ((Integer)aoeState.m_61143_((Property)FarmBlock.f_53243_)).intValue()) < 7) {
                level.m_7731_(aoePos, (BlockState)aoeState.m_61124_((Property)FarmBlock.f_53243_, (Comparable)Integer.valueOf(7)), 3);
            }
        });
        RandomSource random = Utils.RANDOM;
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.m_7918_(x, 0, z).m_123341_() + random.m_188501_();
                double d1 = (double)pos.m_7918_(x, 0, z).m_123342_() + 1.0;
                double d2 = (float)pos.m_7918_(x, 0, z).m_123343_() + random.m_188501_();
                BlockState state = level.m_8055_(pos);
                if (state.m_60815_() || state.m_60734_() instanceof FarmBlock) {
                    d1 += 0.3;
                }
                level.m_7106_((ParticleOptions)ParticleTypes.f_123761_, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        BaseWateringCanItem.startPlayingSound(player);
        if (!level.m_5776_() && Math.random() <= this.chance) {
            BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(aoePos -> {
                BlockState state = level.m_8055_(aoePos);
                Block plantBlock = state.m_60734_();
                if (plantBlock instanceof BonemealableBlock || plantBlock instanceof IPlantable || plantBlock == Blocks.f_50195_ || plantBlock == Blocks.f_50491_) {
                    state.m_222972_((ServerLevel)level, aoePos, random);
                }
            });
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    protected boolean allowFakePlayerWatering() {
        return true;
    }

    public static void startPlayingSound(Player player) {
        if (player.m_9236_().m_5776_()) {
            WateringCanUtil.startPlayingSound(player);
        }
    }

    public static void stopPlayingSound(Player player) {
        if (player.m_9236_().m_5776_()) {
            WateringCanUtil.stopPlayingSound(player);
        }
    }

    private static int getThrottleTicks(Player player) {
        return player instanceof FakePlayer ? 10 : 5;
    }

    static class ItemRenderProperties
    implements IClientItemExtensions {
        public static final IClientItemExtensions INSTANCE = new ItemRenderProperties();

        ItemRenderProperties() {
        }

        public boolean applyForgeHandTransform(PoseStack matrix, LocalPlayer player, HumanoidArm arm, ItemStack stack, float partialTick, float equipProcess, float swingProcess) {
            if (player.m_6117_() && player.m_21212_() > 0) {
                float f = player.m_21212_() % 20;
                float f1 = f - partialTick + 1.0f;
                float f2 = 1.0f - f1 / 20.0f;
                float f7 = -10.0f + 10.0f * Mth.m_14089_((float)(f2 * 2.0f * (float)Math.PI));
                matrix.m_252781_(Axis.f_252529_.m_252977_(f7));
            }
            return false;
        }
    }
}

