/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryInputOutputBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.inventory.DuctItemHandler;
import slimeknights.tconstruct.smeltery.block.entity.inventory.DuctTankWrapper;
import slimeknights.tconstruct.smeltery.menu.SingleItemContainerMenu;

public class DuctBlockEntity
extends SmelteryInputOutputBlockEntity.SmelteryFluidIO
implements MenuProvider {
    private static final String TAG_ITEM = "item";
    private static final Component TITLE = TConstruct.makeTranslation("gui", "duct");
    private final DuctItemHandler itemHandler = new DuctItemHandler(this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);

    public DuctBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TinkerSmeltery.duct.get(), pos, state);
    }

    protected DuctBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public Component m_5446_() {
        return TITLE;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player playerEntity) {
        return new SingleItemContainerMenu(id, inventory, (BlockEntity)this);
    }

    @Override
    @Nonnull
    public <C> LazyOptional<C> getCapability(Capability<C> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Override
    protected LazyOptional<IFluidHandler> makeWrapper(LazyOptional<IFluidHandler> capability) {
        return LazyOptional.of(() -> new DuctTankWrapper((IFluidHandler)capability.orElse((Object)((IFluidHandler)this.emptyInstance)), this.itemHandler));
    }

    @Override
    @Nonnull
    public ModelData getModelData() {
        return RetexturedHelper.getModelDataBuilder((Block)this.getTexture()).with(ModelProperties.FLUID_STACK, (Object)this.itemHandler.getFluid().copy()).build();
    }

    public void updateFluid() {
        this.requestModelDataUpdate();
        assert (this.f_58857_ != null);
        BlockState state = this.m_58900_();
        this.f_58857_.m_7260_(this.f_58858_, state, state, 48);
    }

    @Override
    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_(TAG_ITEM, 10)) {
            this.itemHandler.readFromNBT(tags.m_128469_(TAG_ITEM));
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.updateFluid();
        }
    }

    @Override
    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        tags.m_128365_(TAG_ITEM, (Tag)this.itemHandler.writeToNBT());
    }

    public DuctItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

