/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ClearStainedGlassBlock
extends AbstractGlassBlock {
    private final GlassColor glassColor;

    public ClearStainedGlassBlock(BlockBehaviour.Properties properties, GlassColor glassColor) {
        super(properties);
        this.glassColor = glassColor;
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, LevelReader world, BlockPos pos, BlockPos beaconPos) {
        return this.glassColor.getRgb();
    }

    public static enum GlassColor implements StringRepresentable
    {
        WHITE(0xFFFFFF, DyeColor.WHITE),
        ORANGE(14188339, DyeColor.ORANGE),
        MAGENTA(11685080, DyeColor.MAGENTA),
        LIGHT_BLUE(6724056, DyeColor.LIGHT_BLUE),
        YELLOW(0xE5E533, DyeColor.YELLOW),
        LIME(8375321, DyeColor.LIME),
        PINK(15892389, DyeColor.PINK),
        GRAY(0x4C4C4C, DyeColor.GRAY),
        LIGHT_GRAY(0x999999, DyeColor.LIGHT_GRAY),
        CYAN(5013401, DyeColor.CYAN),
        PURPLE(8339378, DyeColor.PURPLE),
        BLUE(3361970, DyeColor.BLUE),
        BROWN(6704179, DyeColor.BROWN),
        GREEN(6717235, DyeColor.GREEN),
        RED(0x993333, DyeColor.RED),
        BLACK(0x191919, DyeColor.BLACK);

        private final int color;
        private final DyeColor dye;
        private final float[] rgb;
        private final String name;

        private GlassColor(int color, DyeColor dye) {
            this.color = color;
            this.dye = dye;
            this.rgb = GlassColor.calcRGB(color);
            this.name = this.name().toLowerCase(Locale.US);
        }

        private static float[] calcRGB(int color) {
            float[] out = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
            return out;
        }

        public int getColor() {
            return this.color;
        }

        public DyeColor getDye() {
            return this.dye;
        }

        public float[] getRgb() {
            return this.rgb;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

