/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.ModifierSalvage;
import slimeknights.tconstruct.library.tools.SlotType;

public abstract class AbstractModifierRecipeBuilder<T extends AbstractModifierRecipeBuilder<T>>
extends AbstractRecipeBuilder<T> {
    protected final ModifierId result;
    protected Ingredient tools = Ingredient.m_204132_(TinkerTags.Items.MODIFIABLE);
    protected int maxToolSize = 16;
    @Nullable
    protected SlotType.SlotCount slots;
    protected int minLevel = 1;
    protected int maxLevel = ModifierEntry.VALID_LEVEL.max();
    protected boolean useSalvageMax = false;
    protected boolean allowCrystal = true;
    protected boolean checkTraitLevel = false;

    public T setTools(Ingredient tools) {
        return this.setTools(tools, 16);
    }

    public T setTools(Ingredient tools, int maxSize) {
        this.tools = tools;
        this.maxToolSize = maxSize;
        return (T)((Object)this);
    }

    public T setTools(TagKey<Item> tag) {
        return this.setTools(Ingredient.m_204132_(tag));
    }

    @CanIgnoreReturnValue
    public T setMinLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Min level must be greater than 0");
        }
        this.minLevel = level;
        return (T)((Object)this);
    }

    public T setMaxLevel(int level) {
        if (level < 1) {
            throw new IllegalArgumentException("Max level must be greater than 0");
        }
        this.maxLevel = level;
        return (T)((Object)this);
    }

    public T useSalvageMax() {
        this.useSalvageMax = true;
        return (T)((Object)this);
    }

    public T exactLevel(int level) {
        return this.setLevelRange(level, level);
    }

    public T setLevelRange(int min, int max) {
        this.setMinLevel(min);
        this.setMaxLevel(max);
        return (T)((Object)this);
    }

    public T allowCrystal() {
        this.allowCrystal = true;
        return (T)((Object)this);
    }

    public T disallowCrystal() {
        this.allowCrystal = false;
        return (T)((Object)this);
    }

    public T checkTraitLevel() {
        this.checkTraitLevel = true;
        return (T)((Object)this);
    }

    public T setSlots(SlotType slotType, int slots) {
        if (slots < 0) {
            throw new IllegalArgumentException("Slots must be positive");
        }
        this.slots = new SlotType.SlotCount(slotType, slots);
        return (T)((Object)this);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.result);
    }

    public T saveSalvage(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.maxLevel < this.minLevel) {
            throw new IllegalStateException("Max level must be greater than min level");
        }
        if (this.slots == null) {
            throw new IllegalStateException("Must set modifier slots to apply modifier salvage.");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)this.makeSalvage(id), ModifierSalvage.LOADER, advancementId));
        return (T)((Object)this);
    }

    protected ModifierSalvage makeSalvage(ResourceLocation id) {
        return new ModifierSalvage(id, this.tools, this.maxToolSize, this.result, ModifierEntry.VALID_LEVEL.range(this.minLevel, this.useSalvageMax ? this.maxLevel : ModifierEntry.VALID_LEVEL.max()), Objects.requireNonNull(this.slots));
    }

    protected AbstractModifierRecipeBuilder(ModifierId result) {
        this.result = result;
    }
}

