/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.contraptionControls;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsBlockEntity;
import com.simibubi.create.content.contraptions.actors.contraptionControls.ContraptionControlsRenderer;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.elevator.ElevatorContraption;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.IntAttached;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContraptionControlsMovement
implements MovementBehaviour {
    @Override
    public ItemStack canBeDisabledVia(MovementContext context) {
        return null;
    }

    @Override
    public void startMoving(MovementContext context) {
        if (context.contraption instanceof ElevatorContraption && context.blockEntityData != null) {
            context.blockEntityData.m_128473_("Filter");
        }
    }

    @Override
    public void stopMoving(MovementContext context) {
        ItemStack filter = ContraptionControlsMovement.getFilter(context);
        if (filter != null) {
            context.blockEntityData.m_128379_("Disabled", context.contraption.isActorTypeDisabled(filter) || context.contraption.isActorTypeDisabled(ItemStack.f_41583_));
        }
    }

    public static boolean isSameFilter(ItemStack stack1, ItemStack stack2) {
        if (stack1.m_41619_() && stack2.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }

    public static ItemStack getFilter(MovementContext ctx) {
        CompoundTag blockEntityData = ctx.blockEntityData;
        if (blockEntityData == null) {
            return null;
        }
        return ItemStack.m_41712_((CompoundTag)blockEntityData.m_128469_("Filter"));
    }

    public static boolean isDisabledInitially(MovementContext ctx) {
        return ctx.blockEntityData != null && ctx.blockEntityData.m_128471_("Disabled");
    }

    @Override
    public void tick(MovementContext ctx) {
        boolean below;
        if (!ctx.world.m_5776_()) {
            return;
        }
        Contraption contraption = ctx.contraption;
        if (!(contraption instanceof ElevatorContraption)) {
            BlockEntity blockEntity = contraption.presentBlockEntities.get(ctx.localPos);
            if (!(blockEntity instanceof ContraptionControlsBlockEntity)) {
                return;
            }
            ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)blockEntity;
            ItemStack filter = ContraptionControlsMovement.getFilter(ctx);
            int value = contraption.isActorTypeDisabled(filter) || contraption.isActorTypeDisabled(ItemStack.f_41583_) ? 180 : 0;
            cbe.indicator.setValue((double)value);
            cbe.indicator.updateChaseTarget((float)value);
            cbe.tickAnimations();
            return;
        }
        ElevatorContraption ec = (ElevatorContraption)contraption;
        if (!(ctx.temporaryData instanceof ElevatorFloorSelection)) {
            ctx.temporaryData = new ElevatorFloorSelection();
        }
        ElevatorFloorSelection efs = (ElevatorFloorSelection)ctx.temporaryData;
        ContraptionControlsMovement.tickFloorSelection(efs, ec);
        BlockEntity value = contraption.presentBlockEntities.get(ctx.localPos);
        if (!(value instanceof ContraptionControlsBlockEntity)) {
            return;
        }
        ContraptionControlsBlockEntity cbe = (ContraptionControlsBlockEntity)value;
        cbe.tickAnimations();
        int currentY = (int)Math.round(contraption.entity.m_20186_() + (double)ec.getContactYOffset());
        boolean atTargetY = ec.clientYTarget == currentY;
        LerpedFloat indicator = cbe.indicator;
        float currentIndicator = indicator.getChaseTarget();
        boolean bl = atTargetY ? currentIndicator > 0.0f : (below = ec.clientYTarget <= currentY);
        if (currentIndicator == 0.0f && !atTargetY) {
            int startingPoint = below ? 181 : -181;
            indicator.setValue((double)startingPoint);
            indicator.updateChaseTarget((float)startingPoint);
            cbe.tickAnimations();
            return;
        }
        int currentStage = Mth.m_14143_((float)((currentIndicator % 360.0f + 360.0f) % 360.0f));
        if (!atTargetY || currentStage / 45 != 0) {
            float increment = currentStage / 45 == (below ? 4 : 3) ? 2.25f : 33.75f;
            indicator.chase((double)(currentIndicator + (below ? increment : -increment)), 45.0, LerpedFloat.Chaser.LINEAR);
            return;
        }
        indicator.setValue(0.0);
        indicator.updateChaseTarget(0.0f);
    }

    public static void tickFloorSelection(ElevatorFloorSelection efs, ElevatorContraption ec) {
        if (ec.namesList.isEmpty()) {
            efs.currentShortName = "X";
            efs.currentLongName = "No Floors";
            efs.currentIndex = 0;
            efs.targetYEqualsSelection = true;
            return;
        }
        efs.currentIndex = Mth.m_14045_((int)efs.currentIndex, (int)0, (int)(ec.namesList.size() - 1));
        IntAttached<Couple<String>> entry = ec.namesList.get(efs.currentIndex);
        efs.currentTargetY = (Integer)entry.getFirst();
        efs.currentShortName = (String)((Couple)entry.getSecond()).getFirst();
        efs.currentLongName = (String)((Couple)entry.getSecond()).getSecond();
        boolean bl = efs.targetYEqualsSelection = efs.currentTargetY == ec.clientYTarget;
        if (ec.isTargetUnreachable(efs.currentTargetY)) {
            efs.currentLongName = CreateLang.translate("contraption.controls.floor_unreachable", new Object[0]).string();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderInContraption(MovementContext ctx, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        ContraptionControlsRenderer.renderInContraption(ctx, renderWorld, matrices, buffer);
    }

    public static class ElevatorFloorSelection {
        public int currentIndex = 0;
        public int currentTargetY = 0;
        public boolean targetYEqualsSelection = true;
        public String currentShortName = "";
        public String currentLongName = "";
    }
}

