/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.mixin;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.animation.animator.ModelAnimator;
import com.faboslav.variantsandventures.common.client.model.AnimatedEntityModel;
import com.faboslav.variantsandventures.common.entity.animation.AnimatedEntity;
import com.faboslav.variantsandventures.common.entity.pose.SkeletonEntityPose;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.SkeletonModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={SkeletonModel.class})
public abstract class SkeletonEntityModelMixin<T extends Mob>
extends HumanoidModel<T>
implements AnimatedEntityModel {
    protected ModelPart root;

    public SkeletonEntityModelMixin(ModelPart root) {
        super(root);
        this.root = root;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void variantsandventures$SkeletonEntityModelMixin(ModelPart root, CallbackInfo ci) {
        this.root = root;
    }

    @Override
    public ModelPart variantsandventures$getPart() {
        return this.root;
    }

    private void variantsandventures$updateKeyframeAnimations(AnimatedEntity animatedEntity, float animationProgress) {
        animatedEntity.getAnimations().forEach(keyframeAnimation -> ModelAnimator.updateKeyframeAnimations(animatedEntity, this, keyframeAnimation, animationProgress));
    }

    private void variantsandventures$updateMovementKeyframeAnimations(AnimatedEntity animatedEntity, float limbAngle, float limbDistance, float limbAngleScale, float limbDistanceScale) {
        long l = (long)(limbAngle * 50.0f * limbAngleScale);
        float f = Math.min(limbDistance * limbDistanceScale, 1.0f);
        ModelAnimator.updateMovementKeyframeAnimations(animatedEntity, this, l, f);
    }

    @Inject(method={"setAngles"}, at={@At(value="HEAD")}, cancellable=true)
    public void variantsandventures$setAngles(T skeleton, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch, CallbackInfo ci) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants) {
            this.variantsandventures$getPart().m_171331_().forEach(ModelPart::m_233569_);
            if (skeleton.m_217003_(SkeletonEntityPose.EMERGE.get())) {
                this.variantsandventures$updateMovementKeyframeAnimations((AnimatedEntity)skeleton, limbAngle, limbDistance, 1.5f, 2.5f);
                this.variantsandventures$updateKeyframeAnimations((AnimatedEntity)skeleton, animationProgress);
                ci.cancel();
            }
        }
    }
}

