/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.ai;

import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.SnowballItem;

public final class GelidSnowballRangedAttackGoal
extends Goal {
    private final GelidEntity gelid;
    private LivingEntity target;
    private int seenTargetTicks;
    private final float maxShootRange;
    private final float squaredMaxShootRange;

    public GelidSnowballRangedAttackGoal(GelidEntity gelid, float maxShootRange) {
        this.gelid = gelid;
        this.maxShootRange = maxShootRange;
        this.squaredMaxShootRange = maxShootRange * maxShootRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.gelid.m_5448_();
        if (livingEntity == null || !livingEntity.m_6084_() || !(this.gelid.m_21206_().m_41720_() instanceof SnowballItem)) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.gelid.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seenTargetTicks = 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double d = this.gelid.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean bl = this.gelid.m_21574_().m_148306_((Entity)this.target);
        this.seenTargetTicks = bl ? ++this.seenTargetTicks : 0;
        if (!(d > (double)this.squaredMaxShootRange) && this.seenTargetTicks >= 5) {
            this.gelid.m_21573_().m_26573_();
        } else {
            this.gelid.m_21573_().m_5624_((Entity)this.target, 1.0);
        }
        this.gelid.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (!bl) {
            return;
        }
        float f = (float)Math.sqrt(d) / this.maxShootRange;
        float g = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
        this.gelid.throwSnowball(this.target, g);
    }
}

