/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.projectet.ae2things.AE2Things;
import io.github.projectet.ae2things.item.AETItems;
import io.github.projectet.ae2things.storage.IDISKCellItem;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;

public class Command {
    static LiteralCommandNode<CommandSourceStack> commandRoot = ((LiteralArgumentBuilder)Commands.m_82127_((String)"ae2things").executes(Command::help)).build();
    static LiteralCommandNode<CommandSourceStack> recoverArg = ((LiteralArgumentBuilder)Commands.m_82127_((String)"ae2things").then(Commands.m_82127_((String)"recover").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"uuid", (ArgumentType)UuidArgument.m_113850_()).requires(serverCommandSource -> serverCommandSource.m_6761_(2))).executes(context -> Command.spawnDrive((CommandContext<CommandSourceStack>)context, (UUID)context.getArgument("uuid", UUID.class)))))).build();
    static LiteralCommandNode<CommandSourceStack> copyUUID = ((LiteralArgumentBuilder)Commands.m_82127_((String)"ae2things").then(Commands.m_82127_((String)"getuuid").executes(Command::getUUID))).build();

    public static void commandRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.getRoot().addChild(commandRoot);
        dispatcher.getRoot().addChild(recoverArg);
        dispatcher.getRoot().addChild(copyUUID);
    }

    private static int help(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Available Argument(s): "), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/ae2things recover <UUID> - Spawns a drive with the given UUID, if it doesn't exist, does not spawn any item."), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"/ae2things getuuid - Gets the UUID of the drive in the player's hand if it has a UUID. Returns the DISKS uuid."), false);
        return 0;
    }

    private static int spawnDrive(CommandContext<CommandSourceStack> context, UUID uuid) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        if (AE2Things.STORAGE_INSTANCE.hasUUID(uuid)) {
            ItemStack stack = new ItemStack((ItemLike)AETItems.DISK_DRIVE_256K.get());
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("diskuuid", uuid);
            nbt.m_128356_("ic", AE2Things.STORAGE_INSTANCE.getOrCreateDisk((UUID)uuid).itemCount);
            stack.m_41751_(nbt);
            player.m_36356_(stack);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Command.lambda$spawnDrive$5((Player)player, uuid), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"command.ae2things.recover_fail", (Object[])new Object[]{uuid}));
        return 1;
    }

    private static int getUUID(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ItemStack mainStack = player.m_21205_();
        if (mainStack.m_41720_() instanceof IDISKCellItem) {
            if (mainStack.m_41782_() && mainStack.m_41783_().m_128441_("diskuuid")) {
                Component text = Command.copyToClipboard(mainStack.m_41783_().m_128342_("diskuuid").toString());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"command.ae2things.getuuid_success", (Object[])new Object[]{text}), false);
                return 0;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.ae2things.getuuid_fail_nouuid"));
            return 1;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.ae2things.getuuid_fail_notdisk"));
        return 1;
    }

    private static Component copyToClipboard(String string) {
        return Component.m_237113_((String)string).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, string)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))).m_131138_(string).m_131140_(ChatFormatting.GREEN));
    }

    private static /* synthetic */ Component lambda$spawnDrive$5(Player player, UUID uuid) {
        return Component.m_237110_((String)"command.ae2things.recover_success", (Object[])new Object[]{player.m_5446_(), uuid});
    }
}

