/*
 * Decompiled with CFR 0.152.
 */
package dev.orderedchaos.createcustomportalscompat;

import com.mojang.logging.LogUtils;
import com.simibubi.create.api.contraption.train.PortalTrackProvider;
import com.simibubi.create.content.contraptions.glue.SuperGlueEntity;
import net.createmod.catnip.math.BlockFace;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.CustomTeleporter;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="createcustomportalscompat")
public class CreateCustomPortalsCompat {
    public static final String MODID = "createcustomportalscompat";
    private static final Logger LOGGER = LogUtils.getLogger();

    public CreateCustomPortalsCompat(FMLJavaModLoadingContext context) {
        context.getModEventBus().addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CustomPortalBlock customPortal = CustomPortalsMod.getDefaultPortalBlock();
            PortalTrackProvider.REGISTRY.register((Object)customPortal, CreateCustomPortalsCompat::customPortal);
        });
    }

    private static PortalTrackProvider.Exit customPortal(ServerLevel level, BlockFace inboundTrack) {
        ResourceKey overworld = Level.f_46428_;
        BlockPos portalPos = inboundTrack.getConnectedPos();
        Block frameBlock = CustomPortalHelper.getPortalBase((Level)level, (BlockPos)portalPos);
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase((Block)frameBlock);
        ResourceKey destKey = (ResourceKey)CustomPortalsMod.dims.get(link.dimID);
        LOGGER.debug("Found frame block {} from portal at {} - portal goes to dimension {}", new Object[]{frameBlock.m_49954_(), portalPos, destKey});
        ResourceKey resourceKey = level.m_46472_() == destKey ? overworld : destKey;
        MinecraftServer minecraftServer = level.m_7654_();
        ServerLevel otherLevel = minecraftServer.m_129880_(resourceKey);
        if (otherLevel == null) {
            return null;
        }
        BlockState portalState = level.m_8055_(portalPos);
        SuperGlueEntity probe = new SuperGlueEntity((Level)level, new AABB(portalPos));
        probe.m_146922_(inboundTrack.getFace().m_122435_());
        probe.setPortalEntrancePos();
        PortalInfo portalInfo = CustomTeleporter.customTPTarget((ServerLevel)otherLevel, (Entity)probe, (BlockPos)portalPos, (Block)frameBlock, (PortalFrameTester.PortalFrameTesterFactory)link.getFrameTester());
        if (portalInfo == null) {
            return null;
        }
        BlockPos otherPortalPos = BlockPos.m_274446_((Position)portalInfo.f_77676_);
        BlockState otherPortalState = otherLevel.m_8055_(otherPortalPos);
        if (!otherPortalState.m_60713_(portalState.m_60734_())) {
            return null;
        }
        Direction targetDirection = inboundTrack.getFace();
        if (targetDirection.m_122434_() == otherPortalState.m_61143_((Property)CustomPortalBlock.AXIS)) {
            targetDirection = targetDirection.m_122427_();
        }
        BlockPos otherPos = otherPortalPos.m_121945_(targetDirection);
        return new PortalTrackProvider.Exit(otherLevel, new BlockFace(otherPos, targetDirection.m_122424_()));
    }
}

