/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.rechiseledae2.common.data;

import com.christofmeg.rechiseledae2.client.data.BlockTextureProvider;
import com.christofmeg.rechiseledae2.client.data.FusionBlockStateProvider;
import com.christofmeg.rechiseledae2.client.data.ModBlockStateProvider;
import com.christofmeg.rechiseledae2.client.data.ModItemModelProvider;
import com.christofmeg.rechiseledae2.client.data.ModLanguageProvider;
import com.christofmeg.rechiseledae2.common.data.ModBlockTagsProvider;
import com.christofmeg.rechiseledae2.common.data.RechiseledRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rechiseledae2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private static final String[] LOCALE_CODES = new String[]{"en_us"};

    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeClient()) {
            gen.addProvider(true, (DataProvider)new BlockTextureProvider(gen, existingFileHelper));
            gen.addProvider(true, (DataProvider)new ModBlockStateProvider(output, existingFileHelper));
            gen.addProvider(true, (DataProvider)new FusionBlockStateProvider(output, existingFileHelper));
            gen.addProvider(true, (DataProvider)new ModItemModelProvider(output, existingFileHelper));
        }
        if (event.includeServer()) {
            ModBlockTagsProvider blockTags = (ModBlockTagsProvider)gen.addProvider(true, (DataProvider)new ModBlockTagsProvider(output, lookupProvider, existingFileHelper));
            gen.addProvider(true, (DataProvider)new RechiseledRecipeProvider(gen));
        }
        for (String locale : LOCALE_CODES) {
            gen.addProvider(true, (DataProvider)new ModLanguageProvider(output, locale));
        }
    }
}

