/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;

public class Configurations {
    public static final Configurations INSTANCE = new Configurations();
    private final ForgeConfigSpec configSpec;
    public final ForgeConfigSpec.BooleanValue disableCTM;
    public final ForgeConfigSpec.BooleanValue connectInsideCTM;

    public static void register(ModContainer modContainer, IEventBus modBus) {
        modContainer.addConfig(new ModConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configurations.INSTANCE.configSpec, modContainer, "ctm.toml"));
        modBus.addListener(Configurations::reloadEvent);
    }

    private static void reloadEvent(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("ctm")) {
            AbstractCTMBakedModel.invalidateCaches();
            RenderSystem.recordRenderCall(() -> Minecraft.m_91087_().f_91060_.m_109818_());
        }
    }

    private Configurations() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.disableCTM = builder.translation("configuration.ctm.disable").comment("Disable connected textures entirely").define("disableCTM", false);
        this.connectInsideCTM = builder.translation("configuration.ctm.connect_inside").comment("Choose whether the inside corner is disconnected on a CTM block - https://imgur.com/eUywLZ4").define("connectInsideCTM", false);
        this.configSpec = builder.build();
    }

    public static boolean isDisabled() {
        return (Boolean)Configurations.INSTANCE.disableCTM.get();
    }

    public static boolean connectInsideCTM() {
        if (Configurations.INSTANCE.configSpec.isLoaded()) {
            return (Boolean)Configurations.INSTANCE.disableCTM.get();
        }
        return (Boolean)Configurations.INSTANCE.disableCTM.getDefault();
    }
}

