/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.jei;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.compat.jei.AgriCraftJeiPlugin;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.BooleanSupplier;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CropRequirementCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation ID = new ResourceLocation("agricraft", "jei/requirement");
    public static final RecipeType<Recipe> TYPE = new RecipeType(ID, Recipe.class);
    public static final IDrawable BACKGROUND = AgriCraftJeiPlugin.createDrawable(new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128);
    public static final ResourceLocation COMPONENTS = new ResourceLocation("agricraft", "textures/gui/jei/crop_requirement_components.png");
    public static final ResourceLocation GUI_COMPONENTS = new ResourceLocation("agricraft", "textures/gui/gui_components.png");
    public static final int[] HUMIDITY_OFFSETS = new int[]{8, 8, 10, 10, 10, 7};
    public static final int[] ACIDITY_OFFSETS = new int[]{7, 8, 7, 8, 8, 8, 6};
    public static final int[] NUTRIENTS_OFFSETS = new int[]{6, 8, 9, 9, 11, 10};
    public final IDrawable icon;
    public long lastTime;

    public CropRequirementCategory(IGuiHelper helper) {
        this.icon = helper.createDrawableItemStack(new ItemStack((ItemLike)Blocks.f_50093_));
        this.lastTime = System.currentTimeMillis();
    }

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"agricraft.gui.jei.requirement");
    }

    public IDrawable getBackground() {
        return BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.setShapeless();
        builder.addSlot(RecipeIngredientRole.INPUT, 56, 3).setSlotName("input_seed").addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)AgriSeedItem.toStack(recipe.plant));
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        long l;
        int i;
        int offset;
        int index;
        recipe.incStrButton.m_87963_(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.decStrButton.m_87963_(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.incStageButton.m_87963_(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        recipe.decStageButton.m_87963_(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
        for (int i2 = 0; i2 < recipe.currentStrength; ++i2) {
            guiGraphics.m_280163_(COMPONENTS, 105, 66 - i2 * 5, 0.0f, 66.0f, 7, 3, 128, 128);
        }
        int maxHeight = 48;
        int stageHeight = (int)((double)maxHeight * recipe.currentStage.growthPercentage());
        int stageY = 21 + maxHeight - stageHeight;
        guiGraphics.m_280411_(COMPONENTS, 93, stageY, 7, stageHeight, 0.0f, 69.0f, 7, 1, 128, 128);
        for (int i3 = 15; i3 >= 0; --i3) {
            boolean fertile = AgriGrowthConditionRegistry.getLight().apply(recipe.plant, recipe.currentStrength, i3).isFertile();
            if (!fertile) continue;
            guiGraphics.m_280411_(COMPONENTS, 32, 26 + 3 * (15 - i3), 3, 3, 0.0f, (float)(18 + 3 * (15 - i3)), 3, 3, 128, 128);
        }
        for (AgriSoilCondition.Humidity humidity : AgriSoilCondition.Humidity.values()) {
            if (!humidity.isValid() || !AgriGrowthConditionRegistry.getHumidity().apply(recipe.plant, recipe.currentStrength, humidity).isFertile()) continue;
            index = humidity.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += HUMIDITY_OFFSETS[i];
            }
            guiGraphics.m_280411_(GUI_COMPONENTS, 37 + offset, 83, HUMIDITY_OFFSETS[index], 12, (float)offset, 0.0f, HUMIDITY_OFFSETS[index], 12, 128, 128);
        }
        for (Enum enum_ : AgriSoilCondition.Acidity.values()) {
            if (!((AgriSoilCondition.Acidity)enum_).isValid() || !AgriGrowthConditionRegistry.getAcidity().apply(recipe.plant, recipe.currentStrength, (AgriSoilCondition.Acidity)enum_).isFertile()) continue;
            index = enum_.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += ACIDITY_OFFSETS[i];
            }
            guiGraphics.m_280411_(GUI_COMPONENTS, 37 + offset, 96, ACIDITY_OFFSETS[index], 12, (float)offset, 12.0f, ACIDITY_OFFSETS[index], 12, 128, 128);
        }
        for (Enum enum_ : AgriSoilCondition.Nutrients.values()) {
            if (!((AgriSoilCondition.Nutrients)enum_).isValid() || !AgriGrowthConditionRegistry.getNutrients().apply(recipe.plant, recipe.currentStrength, (AgriSoilCondition.Nutrients)enum_).isFertile()) continue;
            index = enum_.ordinal();
            offset = 0;
            for (i = 0; i < index; ++i) {
                offset += NUTRIENTS_OFFSETS[i];
            }
            guiGraphics.m_280411_(GUI_COMPONENTS, 37 + offset, 109, NUTRIENTS_OFFSETS[index], 12, (float)offset, 24.0f, NUTRIENTS_OFFSETS[index], 12, 128, 128);
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            for (Enum enum_ : AgriSeason.values()) {
                if (enum_ == AgriSeason.ANY || !AgriGrowthConditionRegistry.getSeason().apply(recipe.plant, recipe.currentStrength, (AgriSeason)enum_).isFertile()) continue;
                guiGraphics.m_280163_(GUI_COMPONENTS, 17, 24 + 13 * enum_.ordinal(), (float)(10 * enum_.ordinal()), 44.0f, 10, 12, 128, 128);
            }
        }
        if (this.lastTime + 1500L <= (l = System.currentTimeMillis()) && !Screen.m_96638_()) {
            recipe.tick();
            this.lastTime = l;
        }
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        Lighting.m_84930_();
        stack.m_252880_(56.0f, 53.0f, 0.0f);
        stack.m_252880_(-4.0f, 12.0f, 0.0f);
        stack.m_85841_(16.0f, -16.0f, 1.0f);
        stack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        if (!recipe.soils.isEmpty() && recipe.soil < recipe.soils.size()) {
            stack.m_85836_();
            Minecraft.m_91087_().m_91289_().m_110912_(recipe.soils.get(recipe.soil).m_49966_(), stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
            stack.m_85849_();
        }
        BakedModel model = AgriClientApi.getPlantModel(recipe.plantId, recipe.currentStage.index());
        stack.m_85836_();
        stack.m_252880_(0.0f, 1.0f, 0.0f);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(stack.m_85850_(), guiGraphics.m_280091_().m_6299_(RenderType.m_110457_()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_);
        stack.m_85849_();
        bufferSource.m_109911_();
        stack.m_85849_();
    }

    public boolean handleInput(Recipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        int mouseButton;
        if (input.m_84868_() == InputConstants.Type.MOUSE && (mouseButton = input.m_84873_()) == 0) {
            if (recipe.incStrButton.m_5953_(mouseX, mouseY)) {
                recipe.incStrButton.m_5691_();
                return true;
            }
            if (recipe.decStrButton.m_5953_(mouseX, mouseY)) {
                recipe.decStrButton.m_5691_();
                return true;
            }
            if (recipe.incStageButton.m_5953_(mouseX, mouseY)) {
                recipe.incStageButton.m_5691_();
                return true;
            }
            if (recipe.decStageButton.m_5953_(mouseX, mouseY)) {
                recipe.decStageButton.m_5691_();
                return true;
            }
        }
        return super.handleInput((Object)recipe, mouseX, mouseY, input);
    }

    public List<Component> getTooltipStrings(Recipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int i;
        int offset;
        if (104.0 <= mouseX && mouseX <= 113.0 && 20.0 <= mouseY && mouseY <= 70.0) {
            return List.of(Component.m_237110_((String)"agricraft.tooltip.jei.strength", (Object[])new Object[]{recipe.currentStrength}));
        }
        if (92.0 <= mouseX && mouseX <= 101.0 && 20.0 <= mouseY && mouseY <= 70.0) {
            return List.of(Component.m_237110_((String)"agricraft.tooltip.jei.stage", (Object[])new Object[]{recipe.currentStage.index()}));
        }
        if (32.0 <= mouseX && mouseX <= 35.0 && 26.0 <= mouseY && mouseY <= 73.0) {
            int light = 15 - (int)(mouseY - 26.0) / 3;
            return List.of(Component.m_237110_((String)"agricraft.tooltip.jei.light", (Object[])new Object[]{light}));
        }
        if (83.0 <= mouseY && mouseY <= 95.0) {
            offset = 0;
            for (i = 0; i < HUMIDITY_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + HUMIDITY_OFFSETS[i])) {
                    AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.values()[i];
                    return List.of(Component.m_237115_((String)("agricraft.soil.humidity." + humidity.name().toLowerCase())));
                }
                offset += HUMIDITY_OFFSETS[i];
            }
        }
        if (96.0 <= mouseY && mouseY <= 108.0) {
            offset = 0;
            for (i = 0; i < ACIDITY_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + ACIDITY_OFFSETS[i])) {
                    AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.values()[i];
                    return List.of(Component.m_237115_((String)("agricraft.soil.acidity." + acidity.name().toLowerCase())));
                }
                offset += ACIDITY_OFFSETS[i];
            }
        }
        if (109.0 <= mouseY && mouseY <= 121.0) {
            offset = 0;
            for (i = 0; i < NUTRIENTS_OFFSETS.length; ++i) {
                if ((double)(37 + offset) <= mouseX && mouseX <= (double)(37 + offset + NUTRIENTS_OFFSETS[i])) {
                    AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.values()[i];
                    return List.of(Component.m_237115_((String)("agricraft.soil.nutrients." + nutrients.name().toLowerCase())));
                }
                offset += NUTRIENTS_OFFSETS[i];
            }
        }
        if (50.0 <= mouseX && mouseX <= 76.0 && 34.0 <= mouseY && mouseY <= 58.0) {
            Component desc = LangUtils.plantDescription(recipe.plantId);
            return desc == null ? List.of(LangUtils.plantName(recipe.plantId)) : List.of(LangUtils.plantName(recipe.plantId), desc);
        }
        if (50.0 <= mouseX && mouseX <= 76.0 && 58.0 <= mouseY && mouseY <= 74.0) {
            return Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)new ItemStack((ItemLike)recipe.soils.get(recipe.soil)));
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            if (17.0 <= mouseX && mouseX <= 29.0 && 24.0 <= mouseY && mouseY <= 36.0) {
                return List.of(LangUtils.seasonName(AgriSeason.SPRING));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 37.0 <= mouseY && mouseY <= 49.0) {
                return List.of(LangUtils.seasonName(AgriSeason.SUMMER));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 50.0 <= mouseY && mouseY <= 62.0) {
                return List.of(LangUtils.seasonName(AgriSeason.AUTUMN));
            }
            if (17.0 <= mouseX && mouseX <= 29.0 && 63.0 <= mouseY && mouseY <= 74.0) {
                return List.of(LangUtils.seasonName(AgriSeason.WINTER));
            }
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public static class Recipe {
        private final AgriPlant plant;
        private final String plantId;
        private final Btn incStrButton;
        private final Btn decStrButton;
        private final Btn incStageButton;
        private final Btn decStageButton;
        private int currentStrength = AgriApi.getStatRegistry().strengthStat().getMin();
        private AgriGrowthStage currentStage;
        private List<Block> soils;
        private int soil;

        public Recipe(AgriPlant plant) {
            this.plant = plant;
            this.plantId = AgriApi.getPlantId(plant).map(ResourceLocation::toString).orElse("");
            this.currentStage = plant.getInitialGrowthStage();
            this.incStrButton = new Btn(104, 10, 9, 9, this::incrementStrength, true);
            this.decStrButton = new Btn(104, 71, 9, 9, this::decrementStrength, false);
            this.incStageButton = new Btn(92, 10, 9, 9, this::incrementStage, true);
            this.decStageButton = new Btn(92, 71, 9, 9, this::decrementStage, false);
            this.updateSoils();
        }

        public boolean incrementStrength() {
            this.currentStrength = Math.min(AgriApi.getStatRegistry().strengthStat().getMax(), this.currentStrength + 1);
            this.updateSoils();
            return true;
        }

        public boolean decrementStrength() {
            this.currentStrength = Math.max(AgriApi.getStatRegistry().strengthStat().getMin(), this.currentStrength - 1);
            this.updateSoils();
            return true;
        }

        public boolean incrementStage() {
            this.currentStage = this.currentStage.getNext(null, null);
            return true;
        }

        public boolean decrementStage() {
            this.currentStage = this.currentStage.getPrevious(null, null);
            return true;
        }

        public void updateSoils() {
            this.soils = AgriApi.getSoilRegistry().map(registry -> registry.m_123024_().filter(soil -> {
                boolean humidity = AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, soil.humidity()).isFertile();
                boolean acidity = AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, soil.acidity()).isFertile();
                boolean nutrients = AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, soil.nutrients()).isFertile();
                return humidity && acidity && nutrients;
            }).flatMap(soil -> soil.variants().stream()).flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).distinct().toList()).orElse(List.of());
            this.soil = 0;
        }

        public void tick() {
            ++this.soil;
            if (this.soil >= this.soils.size()) {
                this.soil = 0;
            }
        }
    }

    public static class Btn
    extends AbstractButton {
        private final boolean isIncrement;
        private final BooleanSupplier onPress;

        protected Btn(int x, int y, int width, int height, BooleanSupplier onPress, boolean isIncrement) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.isIncrement = isIncrement;
            this.onPress = onPress;
        }

        public void m_5691_() {
            this.onPress.getAsBoolean();
        }

        protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int vOffset = this.isIncrement ? 9 : 0;
            int uOffset = this.getUOffset();
            this.f_93622_ = this.m_252754_() <= mouseX && mouseX < this.m_252754_() + this.m_5711_() && this.m_252907_() <= mouseY && mouseY < this.m_252907_() + this.m_93694_();
            guiGraphics.m_280163_(COMPONENTS, this.m_252754_(), this.m_252907_(), (float)uOffset, (float)vOffset, 9, 9, 128, 128);
        }

        private int getUOffset() {
            if (Minecraft.m_91087_().f_91067_.m_91560_()) {
                return 9;
            }
            if (this.f_93622_) {
                return 18;
            }
            return 0;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            this.m_168802_(narrationElementOutput);
        }
    }
}

