/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.util;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.block.entity.CropBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.ExtraDataMenuProvider;
import com.agricraft.agricraft.common.util.PlatformRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public abstract class Platform {
    private static Platform platform = null;

    public static void setup(Platform platform) {
        if (Platform.platform == null) {
            Platform.platform = platform;
        }
    }

    public static Platform get() {
        return platform;
    }

    public abstract <T> PlatformRegistry<T> createRegistry(Registry<T> var1, String var2);

    public abstract AgriSeedItem createAgriSeedItem(Item.Properties var1);

    public abstract CropBlockEntity createCropBlockEntity(BlockPos var1, BlockState var2);

    public abstract CreativeModeTab createMainCreativeTab();

    public abstract CreativeModeTab createSeedsCreativeTab();

    public abstract Optional<RegistryAccess> getRegistryAccess();

    public <T> Optional<Registry<T>> getRegistry(ResourceKey<Registry<T>> resourceKey) {
        return this.getRegistryAccess().flatMap(registryAccess -> registryAccess.m_6632_(resourceKey));
    }

    public abstract List<Item> getItemsFromLocation(ExtraCodecs.TagOrElementLocation var1);

    public abstract List<Block> getBlocksFromLocation(ExtraCodecs.TagOrElementLocation var1);

    public abstract List<Fluid> getFluidsFromLocation(ExtraCodecs.TagOrElementLocation var1);

    public Stream<ResourceLocation> getPlantIdsFromTag(ExtraCodecs.TagOrElementLocation tag) {
        if (!tag.f_216196_()) {
            return Stream.of(tag.f_216195_());
        }
        return AgriApi.getPlantRegistry().flatMap(registry -> registry.m_203431_(TagKey.m_203882_(AgriApi.AGRIPLANTS, (ResourceLocation)tag.f_216195_())).map(named -> named.m_203614_().map(holder -> registry.m_7981_((Object)((AgriPlant)holder.m_203334_()))))).orElse(Stream.empty());
    }

    public abstract <T extends AbstractContainerMenu> MenuType<T> createMenuType(MenuFactory<T> var1);

    public abstract void openMenu(ServerPlayer var1, ExtraDataMenuProvider var2);

    public abstract ParticleType<?> getParticleType(ResourceLocation var1);

    @FunctionalInterface
    public static interface MenuFactory<T extends AbstractContainerMenu> {
        public T create(int var1, Inventory var2, FriendlyByteBuf var3);
    }
}

