/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.common.block.CropBlock;
import com.agricraft.agricraft.common.registry.ModBlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TrowelItem
extends Item
implements AgriGenomeProviderItem {
    public TrowelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return AgriApi.getCrop((BlockGetter)context.m_43725_(), context.m_8083_()).map(crop -> this.tryUseOnCrop((AgriCrop)crop, context.m_43722_(), context.m_43723_())).orElseGet(() -> this.tryPlantOnSoil(context.m_43725_(), context.m_8083_(), context.m_43722_(), context.m_43723_()));
    }

    protected InteractionResult tryUseOnCrop(AgriCrop crop, ItemStack heldItem, Player player) {
        if (crop.hasWeeds()) {
            if (player != null && player.m_9236_().m_5776_()) {
                player.m_213846_((Component)Component.m_237115_((String)"agricraft.message.trowel_weed"));
            }
            return InteractionResult.FAIL;
        }
        if (crop.isCrossCropSticks()) {
            return InteractionResult.FAIL;
        }
        if (crop.hasPlant()) {
            return this.tryPickUpPlant(crop, heldItem, player);
        }
        return this.tryPlantOnCropSticks(crop, heldItem, player);
    }

    protected InteractionResult tryPickUpPlant(AgriCrop crop, ItemStack stack, Player player) {
        if (crop.m_58904_() == null || crop.m_58904_().m_5776_()) {
            return InteractionResult.PASS;
        }
        if (this.hasPlant(stack)) {
            if (player != null) {
                player.m_213846_((Component)Component.m_237115_((String)"agricraft.message.trowel_plant"));
            }
            return InteractionResult.FAIL;
        }
        AgriGenome genome = crop.getGenome();
        if (genome != null) {
            this.setPlant(stack, genome, crop.getGrowthStage());
            crop.removeGenome();
        }
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult tryPlantOnCropSticks(AgriCrop crop, ItemStack stack, Player player) {
        if (crop.m_58904_() == null || crop.m_58904_().m_5776_()) {
            return InteractionResult.PASS;
        }
        if (crop.isCrossCropSticks()) {
            return InteractionResult.FAIL;
        }
        if (this.hasPlant(stack)) {
            if (crop.hasCropSticks()) {
                this.getGenome(stack).ifPresent(genome -> this.getGrowthStage(stack).ifPresent(growth -> {
                    this.removePlant(stack);
                    crop.plantGenome((AgriGenome)genome, (LivingEntity)player);
                    crop.setGrowthStage((AgriGrowthStage)growth);
                }));
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null) {
            player.m_213846_((Component)Component.m_237115_((String)"agricraft.message.trowel_no_plant"));
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult tryPlantOnSoil(Level level, BlockPos pos, ItemStack stack, Player player) {
        if (this.hasPlant(stack)) {
            return AgriApi.getCrop((BlockGetter)level, pos.m_7494_()).map(crop -> this.tryPlantOnCropSticks((AgriCrop)crop, stack, player)).orElseGet(() -> this.tryNewPlant(level, pos.m_7494_(), stack, player));
        }
        return InteractionResult.FAIL;
    }

    protected InteractionResult tryNewPlant(Level world, BlockPos pos, ItemStack stack, @Nullable Player player) {
        CropBlock cropBlock;
        BlockState newState;
        if (CoreConfig.plantOffCropSticks && world.m_7731_(pos, newState = (cropBlock = (CropBlock)ModBlocks.CROP.get()).blockStatePlant(cropBlock.m_49966_()), 3)) {
            boolean success = AgriApi.getCrop((BlockGetter)world, pos).map(crop -> this.getGenome(stack).map(genome -> this.getGrowthStage(stack).map(stage -> {
                crop.plantGenome((AgriGenome)genome, (LivingEntity)player);
                crop.setGrowthStage((AgriGrowthStage)stage);
                this.removePlant(stack);
                return true;
            }).orElse(false)).orElse(false)).orElse(false);
            if (success) {
                return InteractionResult.SUCCESS;
            }
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        return InteractionResult.FAIL;
    }

    public void setPlant(ItemStack stack, AgriGenome genome, AgriGrowthStage stage) {
        if (this.hasPlant(stack)) {
            return;
        }
        this.setGenome(stack, genome);
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("growthIndex", stage.index());
        tag.m_128405_("growthTotal", stage.total());
    }

    public void removePlant(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_("growthIndex");
            tag.m_128473_("growthTotal");
            AgriGenome.removeFromNBT(tag);
        }
    }

    public boolean hasPlant(ItemStack itemStack) {
        return this.getGenome(itemStack).isPresent();
    }

    public Optional<AgriGrowthStage> getGrowthStage(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_("growthIndex") && tag.m_128441_("growthTotal")) {
            int growthIndex = tag.m_128451_("growthIndex");
            int growthTotal = tag.m_128451_("growthTotal");
            return Optional.of(new AgriGrowthStage(growthIndex, growthTotal));
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        AgriGenome genome;
        tooltipComponents.add((Component)Component.m_237115_((String)"agricraft.tooltip.trowel").m_130940_(ChatFormatting.DARK_GRAY));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (genome = AgriGenome.fromNBT(tag)) != null) {
            genome.appendHoverText(tooltipComponents, (TooltipFlag)TooltipFlag.f_256730_);
        }
    }
}

