/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPage;
import com.agricraft.agricraft.client.ClientUtil;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.item.journal.EmptyPage;
import com.agricraft.agricraft.common.item.journal.FrontPage;
import com.agricraft.agricraft.common.item.journal.GeneticsPage;
import com.agricraft.agricraft.common.item.journal.GrowthReqsPage;
import com.agricraft.agricraft.common.item.journal.IntroductionPage;
import com.agricraft.agricraft.common.item.journal.MutationsPage;
import com.agricraft.agricraft.common.item.journal.PlantPage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class JournalItem
extends Item {
    public JournalItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_20163_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (level.f_46443_) {
            ClientUtil.openJournalScreen(player, usedHand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = context.m_43722_();
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (blockEntity instanceof SeedAnalyzerBlockEntity) {
            SeedAnalyzerBlockEntity seedAnalyzer = (SeedAnalyzerBlockEntity)blockEntity;
            if (seedAnalyzer.hasJournal()) {
                return InteractionResult.PASS;
            }
            ItemStack remaining = seedAnalyzer.insertJournal(heldItem);
            heldItem.m_41764_(remaining.m_41613_());
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        return stack;
    }

    public static void researchPlant(ItemStack journal, ResourceLocation plantId) {
        CompoundTag tag = journal.m_41784_();
        StringTag idTag = StringTag.m_129297_((String)plantId.toString());
        if (tag.m_128441_("plants")) {
            ListTag plants = tag.m_128437_("plants", 8);
            if (!plants.contains((Object)idTag)) {
                plants.add((Object)idTag);
            }
        } else {
            ListTag plants = new ListTag();
            plants.add((Object)idTag);
            tag.m_128365_("plants", (Tag)plants);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237110_((String)"agricraft.tooltip.journal", (Object[])new Object[]{JournalItem.getResearchedPlants(stack)}).m_130940_(ChatFormatting.GRAY));
    }

    public static JournalData getJournalData(ItemStack journal) {
        return new Data(journal);
    }

    public static int getResearchedPlants(ItemStack journal) {
        CompoundTag tag = journal.m_41783_();
        if (tag == null || !tag.m_128441_("plants")) {
            return 0;
        }
        return tag.m_128437_("plants", 8).size();
    }

    public static class Data
    implements JournalData {
        private final List<ResourceLocation> plants = new ArrayList<ResourceLocation>();
        private final List<JournalPage> pages = new ArrayList<JournalPage>();

        public Data(ItemStack journalStack) {
            CompoundTag tag = journalStack.m_41783_();
            if (tag != null && tag.m_128441_("plants")) {
                ListTag list = tag.m_128437_("plants", 8);
                for (Tag plantTag : list) {
                    ResourceLocation plantId = new ResourceLocation(plantTag.m_7916_());
                    if (!AgriApi.getPlant(plantId).isPresent()) continue;
                    this.plants.add(plantId);
                }
            }
            this.plants.sort(Comparator.comparing(ResourceLocation::toString));
            this.initializePages();
        }

        public void initializePages() {
            this.pages.clear();
            this.pages.add(new FrontPage());
            this.pages.add(new IntroductionPage());
            this.pages.add(new GeneticsPage());
            this.pages.add(new GrowthReqsPage());
            for (ResourceLocation plant : this.plants) {
                PlantPage plantPage = new PlantPage(plant, this.plants);
                this.pages.add(plantPage);
                List<List<ResourceLocation>> mutations = plantPage.getMutationsOffPage();
                int size = mutations.size();
                if (size <= 0) continue;
                int remaining = size;
                int from = 0;
                int to = Math.min(remaining, 18);
                while (remaining > 0) {
                    this.pages.add(new MutationsPage(mutations.subList(from, to)));
                    from = to;
                    to = from + Math.min(remaining -= to - from, 18);
                }
            }
        }

        @Override
        public JournalPage getPage(int index) {
            if (0 <= index && index < this.pages.size()) {
                return this.pages.get(index);
            }
            return new EmptyPage();
        }

        @Override
        public int size() {
            return this.pages.size();
        }

        @Override
        public List<ResourceLocation> getDiscoveredSeeds() {
            return this.plants;
        }
    }
}

