/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.block;

import com.agricraft.agricraft.common.item.CropSticksItem;
import com.agricraft.agricraft.common.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;

public enum CropStickVariant implements StringRepresentable
{
    WOODEN,
    IRON,
    OBSIDIAN;


    public String m_7912_() {
        return this.name().toLowerCase();
    }

    public SoundType getSound() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WOODEN -> SoundType.f_56736_;
            case IRON -> SoundType.f_56749_;
            case OBSIDIAN -> SoundType.f_56718_;
        };
    }

    public void playSound(Level level, BlockPos pos) {
        level.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), this.getSound().m_56777_(), SoundSource.BLOCKS, (this.getSound().m_56773_() + 1.0f) / 4.0f, this.getSound().m_56774_() * 0.8f);
    }

    public static CropStickVariant fromItem(ItemStack stack) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof CropSticksItem)) {
            return null;
        }
        CropSticksItem item2 = (CropSticksItem)item;
        return item2.getVariant();
    }

    public static ItemStack toItem(CropStickVariant variant) {
        return switch (variant) {
            default -> throw new IncompatibleClassChangeError();
            case WOODEN -> new ItemStack((ItemLike)ModItems.WOODEN_CROP_STICKS.get());
            case IRON -> new ItemStack((ItemLike)ModItems.IRON_CROP_STICKS.get());
            case OBSIDIAN -> new ItemStack((ItemLike)ModItems.OBSIDIAN_CROP_STICKS.get());
        };
    }

    public static ItemStack toItem(CropStickVariant variant, int amount) {
        ItemStack stack = CropStickVariant.toItem(variant);
        stack.m_41764_(amount);
        return stack;
    }
}

