/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.tools.journal.drawers;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.journal.PlantPage;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class PlantPageDrawer
implements JournalPageDrawer<PlantPage> {
    private static final Component GROWTH_STAGES = Component.m_237115_((String)"agricraft.journal.growth_stages");
    private static final Component GROWTH_REQUIREMENTS = Component.m_237115_((String)"agricraft.journal.growth_reqs");
    private static final Component PRODUCTS = Component.m_237115_((String)"agricraft.journal.products");
    private static final Component MUTATIONS = Component.m_237115_((String)"agricraft.journal.mutations");

    @Override
    public void drawLeftSheet(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY, JournalData journalData) {
        Font font = Minecraft.m_91087_().f_91062_;
        guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 4, pageY + 9, 0.0f, 56.0f, 128, 20, 128, 128);
        String plantId = AgriApi.getPlantId(page.getPlant()).map(ResourceLocation::toString).orElse("");
        Component plantName = LangUtils.plantName(plantId);
        Component seedName = LangUtils.seedName(plantId);
        int titleWidth = font.m_92852_((FormattedText)plantName);
        if (titleWidth > 74) {
            float scale = 0.8f;
            while ((float)font.m_92852_((FormattedText)seedName) * scale > 74.0f) {
                scale -= 0.1f;
            }
            this.drawScaledText(guiGraphics, seedName, pageX + 30, pageY + 15, scale);
        } else {
            guiGraphics.m_280614_(font, seedName, pageX + 30, pageY + 15, 0, false);
        }
        guiGraphics.m_280480_(AgriSeedItem.toStack(page.getPlant()), pageX + 8, pageY + 11);
        Component plantDescription = LangUtils.plantDescription(plantId);
        float offset = 0.0f;
        if (plantDescription != null) {
            offset = this.drawScaledText(guiGraphics, plantDescription, pageX + 10, pageY + 30, 0.7f);
        }
        pageY = this.drawGrowthRequirements(guiGraphics, page, pageX, pageY, 35.0f + offset);
        this.drawProducts(guiGraphics, page, pageX, pageY);
    }

    @Override
    public void drawRightSheet(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY, JournalData journalData) {
        this.drawMutations(guiGraphics, page, pageX, pageY);
    }

    protected int drawGrowthRequirements(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY, float yOffset) {
        int width;
        int dx;
        int i;
        float dy = (float)pageY + Math.max(yOffset, 60.0f);
        dy += (float)(this.drawScaledText(guiGraphics, GROWTH_REQUIREMENTS, pageX + 10, dy, 0.8f) + 1);
        guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10, (int)dy, 0.0f, 36.0f, 66, 8, 128, 128);
        for (i = 0; i < page.brightnessMask().length; ++i) {
            boolean current = page.brightnessMask()[i];
            if (!current) continue;
            boolean prev = i > 0 && page.brightnessMask()[i - 1];
            boolean next = i < page.brightnessMask().length - 1 && page.brightnessMask()[i + 1];
            guiGraphics.m_280411_(GUI_COMPONENTS, pageX + 10 + 4 * i + 1, (int)dy, 4, 8, 67.0f, 36.0f, 2, 8, 128, 128);
            if (!prev) {
                guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10 + 4 * i, (int)dy, 66.0f, 36.0f, 1, 8, 128, 128);
            }
            if (next) continue;
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10 + 4 * i + 5, (int)dy, 66.0f, 36.0f, 1, 8, 128, 128);
        }
        dy += 9.0f;
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                int x = pageX + 75 + i % 2 * 12;
                int y = (int)(dy + 6.0f + (float)(i / 2 * 12));
                if (page.seasonMask()[i]) {
                    guiGraphics.m_280163_(GUI_COMPONENTS, x, y, (float)(i * 10), 44.0f, 10, 12, 128, 128);
                    continue;
                }
                guiGraphics.m_280163_(GUI_COMPONENTS, x, y, (float)(40 + i * 10), 44.0f, 10, 12, 128, 128);
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = HUMIDITY_OFFSETS[i];
            width = HUMIDITY_OFFSETS[i + 1] - HUMIDITY_OFFSETS[i];
            if (page.humidityMask()[i]) {
                guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 0.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 0.0f, width, 12, 128, 128);
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = ACIDITY_OFFSETS[i];
            width = ACIDITY_OFFSETS[i + 1] - ACIDITY_OFFSETS[i];
            if (page.acidityMask()[i]) {
                guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 12.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 12.0f, width, 12, 128, 128);
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = NUTRIENTS_OFFSETS[i];
            width = NUTRIENTS_OFFSETS[i + 1] - NUTRIENTS_OFFSETS[i];
            if (page.nutrientsMask()[i]) {
                guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)dx, 24.0f, width, 12, 128, 128);
                continue;
            }
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + dx + 10, (int)dy, (float)(dx + 53), 24.0f, width, 12, 128, 128);
        }
        return (int)(dy + 13.0f);
    }

    protected void drawProducts(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY) {
        this.drawScaledText(guiGraphics, PRODUCTS, pageX + 10, pageY + 10, 0.8f);
        for (int i = 0; i < page.getProducts().size(); ++i) {
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10 + i * 20, pageY + 19, 0.0f, 76.0f, 18, 18, 128, 128);
            guiGraphics.m_280480_(page.getProducts().get(i), pageX + 11 + i * 20, pageY + 20);
        }
    }

    protected void drawMutations(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY) {
        this.drawScaledText(guiGraphics, MUTATIONS, pageX + 10, pageY + 15, 0.8f);
        for (List<ResourceLocation> plants : page.getMutationsOnPage()) {
            guiGraphics.m_280163_(GUI_COMPONENTS, pageX + 10, pageY + 24, 0.0f, 76.0f, 86, 18, 128, 128);
            TextureAtlasSprite parent1 = AgriClientApi.getPlantModel(plants.get(0), (int)AgriApi.getPlant(plants.get(0)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
            TextureAtlasSprite parent2 = AgriClientApi.getPlantModel(plants.get(1), (int)AgriApi.getPlant(plants.get(1)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
            TextureAtlasSprite child = AgriClientApi.getPlantModel(plants.get(2), (int)AgriApi.getPlant(plants.get(2)).map(plant -> plant.getInitialGrowthStage().total() - 1).orElse(0)).m_6160_();
            guiGraphics.m_280159_(pageX + 11, pageY + 25, 1, 16, 16, parent1);
            guiGraphics.m_280159_(pageX + 45, pageY + 25, 1, 16, 16, parent2);
            guiGraphics.m_280159_(pageX + 79, pageY + 25, 1, 16, 16, child);
            pageY += 20;
        }
    }

    @Override
    public void drawLeftTooltip(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY, int mouseX, int mouseY) {
        int w;
        int dx;
        int i;
        Font font = Minecraft.m_91087_().f_91062_;
        String plantId = AgriApi.getPlantId(page.getPlant()).map(ResourceLocation::toString).orElse("");
        Component plantName = LangUtils.plantName(plantId);
        Component plantDescription = LangUtils.plantDescription(plantId);
        if (8 <= mouseX && mouseX <= 24 && 11 <= mouseY && mouseY <= 27) {
            guiGraphics.m_280557_(font, plantName, mouseX + pageX, mouseY + pageY);
            return;
        }
        float offset = 35.0f;
        if (plantDescription != null) {
            offset += (float)this.drawScaledText(guiGraphics, plantDescription, -1000.0f, -1000.0f, 0.7f);
        }
        float dy = Math.max(offset, 60.0f);
        dy += (float)(this.drawScaledText(guiGraphics, GROWTH_REQUIREMENTS, -1000.0f, -1000.0f, 0.8f) + 1);
        for (i = 0; i < page.brightnessMask().length; ++i) {
            if (10 + 4 * i > mouseX || mouseX > 10 + 4 * i + 4 || !(dy + 1.0f <= (float)mouseY) || !((float)mouseY <= dy + 9.0f)) continue;
            guiGraphics.m_280557_(font, (Component)Component.m_237115_((String)"agricraft.tooltip.light").m_130946_(" " + i), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 9.0f;
        if (AgriApi.getSeasonLogic().isActive()) {
            for (i = 0; i < page.seasonMask().length; ++i) {
                int x = 75 + i % 2 * 12;
                int y = (int)(dy + 6.0f + (float)(i / 2 * 12));
                if (x > mouseX || mouseX > x + 10 || y > mouseY || mouseY > y + 12) continue;
                guiGraphics.m_280557_(font, LangUtils.seasonName(AgriSeason.values()[i]), mouseX + pageX, mouseY + pageY);
                return;
            }
        }
        for (i = 0; i < page.humidityMask().length; ++i) {
            dx = HUMIDITY_OFFSETS[i] + 10;
            w = HUMIDITY_OFFSETS[i + 1] - HUMIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.m_280557_(font, LangUtils.soilPropertyName("humidity", AgriSoilCondition.Humidity.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.acidityMask().length; ++i) {
            dx = ACIDITY_OFFSETS[i] + 10;
            w = ACIDITY_OFFSETS[i + 1] - ACIDITY_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.m_280557_(font, LangUtils.soilPropertyName("acidity", AgriSoilCondition.Acidity.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 13.0f;
        for (i = 0; i < page.nutrientsMask().length; ++i) {
            dx = NUTRIENTS_OFFSETS[i] + 10;
            w = NUTRIENTS_OFFSETS[i + 1] - NUTRIENTS_OFFSETS[i];
            if (dx > mouseX || mouseX > dx + w || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 12.0f)) continue;
            guiGraphics.m_280557_(font, LangUtils.soilPropertyName("nutrients", AgriSoilCondition.Nutrients.values()[i]), mouseX + pageX, mouseY + pageY);
            return;
        }
        dy += 33.0f;
        for (i = 0; i < page.getProducts().size(); ++i) {
            if (11 + i * 20 > mouseX || mouseX > 11 + i * 20 + 16 || !(dy <= (float)mouseY) || !((float)mouseY <= dy + 16.0f)) continue;
            guiGraphics.m_280153_(font, page.getProducts().get(i), mouseX + pageX, mouseY + pageY);
        }
    }

    @Override
    public void drawRightTooltip(GuiGraphics guiGraphics, PlantPage page, int pageX, int pageY, int mouseX, int mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int y = 0;
        for (List<ResourceLocation> plants : page.getMutationsOnPage()) {
            if (11 <= mouseX && mouseX <= 27 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.m_280557_(font, LangUtils.plantName(plants.get(0).toString()), mouseX + pageX, mouseY + pageY);
            } else if (45 <= mouseX && mouseX <= 61 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.m_280557_(font, LangUtils.plantName(plants.get(1).toString()), mouseX + pageX, mouseY + pageY);
            } else if (79 <= mouseX && mouseX <= 95 && y + 25 <= mouseY && mouseY <= y + 41) {
                guiGraphics.m_280557_(font, LangUtils.plantName(plants.get(2).toString()), mouseX + pageX, mouseY + pageY);
            }
            y += 20;
        }
    }
}

