/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.tools.journal.drawers;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.codecs.AgriSoilValue;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.api.tools.journal.JournalData;
import com.agricraft.agricraft.api.tools.journal.JournalPageDrawer;
import com.agricraft.agricraft.common.item.journal.GrowthReqsPage;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GrowthReqsPageDrawer
implements JournalPageDrawer<GrowthReqsPage> {
    private final Component GROWTH_REQS = Component.m_237115_((String)"agricraft.journal.growth_reqs");
    private final Component PARAGRAPH_L_1 = Component.m_237115_((String)"agricraft.journal.growth_reqs.paragraph_1");
    private final Component BRIGHTNESS = Component.m_237115_((String)"agricraft.journal.growth_reqs.brightness");
    private final Component PARAGRAPH_BRIGHTNESS = Component.m_237115_((String)"agricraft.journal.growth_reqs.brightness.desc");
    private final Component HUMIDITY = Component.m_237115_((String)"agricraft.journal.growth_reqs.humidity");
    private final Component PARAGRAPH_HUMIDITY = Component.m_237115_((String)"agricraft.journal.growth_reqs.humidity.desc");
    private final Component ACIDITY = Component.m_237115_((String)"agricraft.journal.growth_reqs.acidity");
    private final Component PARAGRAPH_ACIDITY = Component.m_237115_((String)"agricraft.journal.growth_reqs.acidity.desc");
    private final Component NUTRIENTS = Component.m_237115_((String)"agricraft.journal.growth_reqs.nutrients");
    private final Component PARAGRAPH_NUTRIENTS = Component.m_237115_((String)"agricraft.journal.growth_reqs.nutrients.desc");
    private final Component SEASONS = Component.m_237115_((String)"agricraft.journal.growth_reqs.seasons");
    private final Component PARAGRAPH_SEASONS = Component.m_237115_((String)"agricraft.journal.growth_reqs.seasons.desc");

    @Override
    public void drawLeftSheet(GuiGraphics guiGraphics, GrowthReqsPage page, int pageX, int pageY, JournalData journalData) {
        Font font = Minecraft.m_91087_().f_91062_;
        float dx = pageX + 6;
        float dy = pageY + 10;
        float spacing = 4.0f;
        guiGraphics.m_280614_(font, this.GROWTH_REQS, (int)dx, (int)dy, 0, false);
        Objects.requireNonNull(font);
        dy += 9.0f;
        dy += spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_L_1, dx, dy, 0.65f);
        dy += spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.BRIGHTNESS, dx, dy, 0.65f);
        guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx, (int)dy, 0.0f, 36.0f, 66, 8, 128, 128);
        dy += spacing + 6.0f;
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_BRIGHTNESS, dx, dy, 0.5f);
        dy += spacing;
        dy += (float)this.drawScaledText(guiGraphics, this.HUMIDITY, dx, dy, 0.65f);
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_HUMIDITY, dx, dy, 0.5f);
        this.drawSoilProperties(guiGraphics, dx, dy, spacing, "humidity", AgriSoilCondition.Humidity.values(), HUMIDITY_OFFSETS, 0);
    }

    @Override
    public void drawRightSheet(GuiGraphics guiGraphics, GrowthReqsPage page, int pageX, int pageY, JournalData journalData) {
        float dx = pageX + 6;
        float dy = pageY + 10;
        float spacing = 4.0f;
        dy += (float)this.drawScaledText(guiGraphics, this.ACIDITY, dx, dy, 0.65f);
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_ACIDITY, dx, dy, 0.5f);
        dy = this.drawSoilProperties(guiGraphics, dx, dy, spacing, "acidity", AgriSoilCondition.Acidity.values(), ACIDITY_OFFSETS, 12);
        dy += (float)this.drawScaledText(guiGraphics, this.NUTRIENTS, dx, dy, 0.65f);
        dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_NUTRIENTS, dx, dy, 0.5f);
        dy = this.drawSoilProperties(guiGraphics, dx, dy, spacing, "nutrients", AgriSoilCondition.Nutrients.values(), NUTRIENTS_OFFSETS, 24);
        if (AgriApi.getSeasonLogic().isActive()) {
            dy += (float)this.drawScaledText(guiGraphics, this.SEASONS, dx, dy, 0.65f);
            dy += (float)this.drawScaledText(guiGraphics, this.PARAGRAPH_SEASONS, dx, dy, 0.5f);
            guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx, (int)dy, 0.0f, 44.0f, 10, 12, 128, 128);
            int offset = this.drawScaledText(guiGraphics, LangUtils.seasonName(AgriSeason.SPRING), dx + 12.0f, dy + 5.0f, 0.5f);
            guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx, (int)(dy + (float)offset + 9.0f), 10.0f, 44.0f, 10, 12, 128, 128);
            this.drawScaledText(guiGraphics, LangUtils.seasonName(AgriSeason.SUMMER), dx + 12.0f, dy + (float)offset + 12.0f, 0.5f);
            guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx + 45, (int)dy, 20.0f, 44.0f, 10, 12, 128, 128);
            offset = this.drawScaledText(guiGraphics, LangUtils.seasonName(AgriSeason.AUTUMN), dx + 45.0f + 12.0f, dy + 5.0f, 0.5f);
            guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx + 45, (int)(dy + (float)offset + 9.0f), 30.0f, 44.0f, 10, 12, 128, 128);
            this.drawScaledText(guiGraphics, LangUtils.seasonName(AgriSeason.WINTER), dx + 45.0f + 12.0f, dy + (float)offset + 12.0f, 0.5f);
        }
    }

    protected float drawSoilProperties(GuiGraphics guiGraphics, float dx, float dy, float spacing, String property, AgriSoilValue[] properties, int[] offsets, int textureOffsetY) {
        for (int i = 0; i < properties.length - 1; ++i) {
            int width = offsets[i + 1] - offsets[i];
            guiGraphics.m_280163_(GUI_COMPONENTS, (int)dx, (int)dy, (float)offsets[i], (float)textureOffsetY, width, 12, 128, 128);
            this.drawScaledText(guiGraphics, LangUtils.soilPropertyName(property, properties[i]), dx + 12.0f, dy + 5.0f, 0.5f);
            dy += 10.0f;
        }
        return dy + spacing;
    }
}

