/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.codecs;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.codecs.AgriSoilVariant;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;

public record AgriSoil(List<String> mods, List<AgriSoilVariant> variants, AgriSoilCondition.Humidity humidity, AgriSoilCondition.Acidity acidity, AgriSoilCondition.Nutrients nutrients, Double growthModifier) implements MagnifyingInspectable
{
    public static final Codec<AgriSoil> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("mods").forGetter(soil -> soil.mods), (App)AgriSoilVariant.CODEC.listOf().fieldOf("variants").forGetter(soil -> soil.variants), (App)AgriSoilCondition.Humidity.CODEC.fieldOf("humidity").forGetter(soil -> soil.humidity), (App)AgriSoilCondition.Acidity.CODEC.fieldOf("acidity").forGetter(soil -> soil.acidity), (App)AgriSoilCondition.Nutrients.CODEC.fieldOf("nutrients").forGetter(soil -> soil.nutrients), (App)Codec.DOUBLE.fieldOf("growth_modifier").forGetter(soil -> soil.growthModifier)).apply((Applicative)instance, AgriSoil::new));

    public static Builder builder() {
        return new Builder();
    }

    public boolean isVariant(BlockState blockState) {
        for (AgriSoilVariant variant : this.variants) {
            List<Block> blocks = Platform.get().getBlocksFromLocation(variant.block());
            if (!blocks.contains(blockState.m_60734_())) continue;
            if (variant.states().isEmpty()) {
                return true;
            }
            Set list = blockState.m_61148_().entrySet().stream().map(StateHolder.f_61110_).collect(Collectors.toSet());
            if (!list.containsAll(variant.states())) continue;
            return true;
        }
        return false;
    }

    public boolean isVariant(Item item) {
        return this.variants.stream().flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).map(Block::m_5456_).anyMatch(it -> it == item);
    }

    @Override
    public void addMagnifyingTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil"));
        tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.soil")).m_7220_(LangUtils.soilName(AgriApi.getSoilId(this).map(ResourceLocation::toString).orElse(""))));
        tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.humidity")).m_7220_(LangUtils.soilPropertyName("humidity", this.humidity)));
        tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.acidity")).m_7220_(LangUtils.soilPropertyName("acidity", this.acidity)));
        tooltip.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)Component.m_237115_((String)"agricraft.tooltip.magnifying.soil.nutrients")).m_7220_(LangUtils.soilPropertyName("nutrients", this.nutrients)));
    }

    public static class Builder {
        List<String> mods = new ArrayList<String>();
        List<AgriSoilVariant> soilVariants = new ArrayList<AgriSoilVariant>();
        AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.INVALID;
        AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.INVALID;
        AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.INVALID;
        double growthModifier = 1.0;

        public AgriSoil build() {
            return new AgriSoil(this.mods, this.soilVariants, this.humidity, this.acidity, this.nutrients, this.growthModifier);
        }

        public Builder defaultMods() {
            Collections.addAll(this.mods, "agricraft", "minecraft");
            return this;
        }

        public Builder mods(String ... mods) {
            Collections.addAll(this.mods, mods);
            return this;
        }

        public Builder variants(AgriSoilVariant ... variants) {
            Collections.addAll(this.soilVariants, variants);
            return this;
        }

        public Builder humidity(AgriSoilCondition.Humidity humidity) {
            this.humidity = humidity;
            return this;
        }

        public Builder acidity(AgriSoilCondition.Acidity acidity) {
            this.acidity = acidity;
            return this;
        }

        public Builder nutrients(AgriSoilCondition.Nutrients nutrients) {
            this.nutrients = nutrients;
            return this;
        }

        public Builder growthModifier(double growthModifier) {
            this.growthModifier = growthModifier;
            return this;
        }
    }
}

