/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.ingredient;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.config.EmiConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class EffectInstanceStack
extends EmiStack {
    private static final EffectRenderer RENDERER = new EffectRenderer(false){};
    private final MobEffectInstance effect;

    public EffectInstanceStack(MobEffectInstance effect) {
        this.effect = effect;
    }

    public EffectInstanceStack(MobEffect effect, long duration) {
        this(new MobEffectInstance(effect, (int)duration));
    }

    public EffectInstanceStack(MobEffect effect) {
        this(effect, 600L);
    }

    public MobEffectInstance getEffect() {
        return this.effect;
    }

    public EmiStack copy() {
        return new EffectInstanceStack(new MobEffectInstance(this.effect.m_19544_(), this.effect.m_19557_(), this.effect.m_19564_(), this.effect.m_19571_(), this.effect.m_19572_(), this.effect.m_19575_(), this.effect.f_19510_, this.effect.m_216895_()));
    }

    public void render(GuiGraphics draw, int x, int y, float delta, int flags) {
        RENDERER.render(draw, this.effect, x - 1, y - 1, 16, 16);
    }

    public boolean isEmpty() {
        return false;
    }

    public CompoundTag getNbt() {
        return null;
    }

    public Object getKey() {
        return this.effect.m_19544_();
    }

    public ResourceLocation getId() {
        return BuiltInRegistries.f_256974_.m_7981_((Object)this.effect.m_19544_());
    }

    public List<Component> getTooltipText() {
        Minecraft client = Minecraft.m_91087_();
        return EffectRenderer.getTooltipsWithDescription(this.effect, (TooltipFlag)(client.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_), false, false);
    }

    public List<ClientTooltipComponent> getTooltip() {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.getTooltipText().stream().map(EmiPort::ordered).map(ClientTooltipComponent::m_169948_).toList());
        ResourceLocation id = this.getId();
        if (EmiConfig.appendModId && id != null) {
            String mod = EmiUtil.getModName((String)id.m_135827_());
            list.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)EmiPort.ordered((Component)EmiPort.literal((String)mod, (ChatFormatting[])new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}))));
        }
        list.addAll(super.getTooltip());
        return list;
    }

    public Component getName() {
        return this.effect.m_19544_().m_19482_();
    }

    public ItemStack getItemStack() {
        ItemStack item = PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), Collections.singletonList(this.normalize()));
        item.m_41784_().m_128405_("CustomPotionColor", this.effect.m_19544_().m_19484_());
        return item;
    }

    public MobEffectInstance normalize() {
        return new MobEffectInstance(this.effect.m_19544_(), 600, 0, this.effect.m_19571_(), this.effect.m_19572_(), this.effect.m_19575_(), this.effect.f_19510_, this.effect.m_216895_());
    }
}

