/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.display;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.Constants;
import net.mehvahdjukaar.jeed.common.EffectWindowEntry;
import net.mehvahdjukaar.jeed.common.HSLColor;
import net.mehvahdjukaar.jeed.plugin.emi.EMIPlugin;
import net.mehvahdjukaar.jeed.plugin.emi.ingredient.EffectInstanceStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class EffectInfoRecipe
extends EffectWindowEntry
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> catalysts;
    private final List<EmiIngredient> slotsContent;
    private final List<EmiIngredient> inputEffects;
    private final EmiStack outputs;

    protected EffectInfoRecipe(MobEffectInstance effectInstance, Component description, ResourceLocation id) {
        super(effectInstance, List.of(description));
        this.id = id;
        this.outputs = new EffectInstanceStack(effectInstance);
        List<ItemStack> providers = EffectInfoRecipe.computeItemProviders(effectInstance.m_19544_());
        List<EmiIngredient> ingredientsList = EffectInfoRecipe.groupIngredients(providers).stream().map(EmiIngredient::of).toList();
        this.catalysts = providers.stream().map(xva$0 -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{xva$0})).map(EmiIngredient::of).toList();
        ingredientsList = new ArrayList<EmiIngredient>(ingredientsList);
        this.inputEffects = EffectInfoRecipe.computeEffectProviders(this.effect.m_19544_()).stream().map(EffectInstanceStack::new).map(e -> e).toList();
        List<EmiIngredient> fluids = EffectInfoRecipe.computeFluidProvides(this.effect.m_19544_()).stream().map(EmiStack::of).map(e -> e).toList();
        ingredientsList.addAll(this.inputEffects);
        ingredientsList.addAll(fluids);
        this.slotsContent = EffectInfoRecipe.divideIntoSlots(ingredientsList, EmiIngredient::of);
    }

    public List<EmiIngredient> getCatalysts() {
        return this.catalysts;
    }

    public EmiRecipeCategory getCategory() {
        return EMIPlugin.CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputEffects;
    }

    public List<EmiStack> getOutputs() {
        return List.of(this.outputs);
    }

    public int getDisplayWidth() {
        return Constants.RECIPE_WIDTH;
    }

    public int getDisplayHeight() {
        return Constants.RECIPE_HEIGHT;
    }

    public void addWidgets(WidgetHolder widgets) {
        MobEffect mobEffect = this.effect.m_19544_();
        MutableComponent name = (MutableComponent)mobEffect.m_19482_();
        int color = HSLColor.getProcessedColor(mobEffect.m_19484_());
        name.m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131148_(TextColor.m_131266_((int)color)));
        Font font = Minecraft.m_91087_().f_91062_;
        int centerX = widgets.getWidth() / 2;
        int nameX = (int)((float)centerX - (float)font.m_92852_((FormattedText)name) / 2.0f);
        widgets.addText((Component)name, nameX, 0, -1, true);
        if (Jeed.hasEffectBox()) {
            widgets.addTexture(ContainerScreen.f_97725_, centerX - 12, Constants.Y_OFFSET, 24, 24, 141, 166);
        }
        widgets.add((Widget)new SlotWidget((EmiIngredient)this.outputs, centerX - 9, Constants.Y_OFFSET + 3).drawBack(false));
        int listH = EffectWindowEntry.getListHeight(this.slotsContent);
        if (listH != 0) {
            int rowsCount = this.slotsContent.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS;
            int size = Constants.SLOTS_PER_ROW * (this.slotsContent.size() <= Constants.SLOTS_PER_ROW ? 1 : Constants.ROWS);
            for (int slotId = 0; slotId < size; ++slotId) {
                Object ingredient = slotId < this.slotsContent.size() ? this.slotsContent.get(slotId) : EmiStack.EMPTY;
                int sx = -1 + (int)((float)centerX + (float)Constants.ROWS + (float)Constants.SLOT_W * ((float)(slotId % Constants.SLOTS_PER_ROW) - (float)Constants.SLOTS_PER_ROW / 2.0f));
                int sy = 1 + widgets.getHeight() - Constants.SLOT_W * (rowsCount - slotId / Constants.SLOTS_PER_ROW);
                SlotWidget slot = new SlotWidget((EmiIngredient)ingredient, sx, sy, (EmiIngredient)ingredient){
                    final /* synthetic */ EmiIngredient val$ingredient;
                    {
                        this.val$ingredient = emiIngredient;
                        super(stack, x, y);
                    }

                    public void drawSlotHighlight(GuiGraphics draw, Bounds bounds) {
                        if (!this.val$ingredient.isEmpty()) {
                            super.drawSlotHighlight(draw, bounds);
                        }
                    }
                };
                widgets.add((Widget)slot);
            }
        }
        int y = 41;
        int n = widgets.getHeight() - y - listH;
        Objects.requireNonNull(font);
        int lineCount = n / 9;
        List<FormattedCharSequence> lines = this.description.stream().flatMap(t -> font.m_92923_(t, this.getDisplayWidth() - 4).stream()).toList();
        PageManager manager = new PageManager(lines, lineCount);
        if (lineCount < lines.size()) {
            widgets.addButton(2, 2, 12, 12, 0, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(-1));
            widgets.addButton(widgets.getWidth() - 14, 2, 12, 12, 12, 0, () -> true, (mouseX, mouseY, button) -> manager.scroll(1));
        }
        widgets.addDrawable(0, y, 0, 0, (raw, mouseX, mouseY, delta) -> {
            EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)raw);
            int lo = manager.start();
            for (int i = 0; i < lineCount; ++i) {
                int l = lo + i;
                if (l >= manager.lines.size()) {
                    return;
                }
                FormattedCharSequence text = manager.lines.get(l);
                Objects.requireNonNull(font);
                context.drawText(text, 0, y - y + i * 9, 0);
            }
        });
    }

    public static EffectInfoRecipe create(MobEffect effect) {
        Component text = EffectInfoRecipe.getDescription(effect);
        return new EffectInfoRecipe(new MobEffectInstance(effect), text, BuiltInRegistries.f_256974_.m_7981_((Object)effect));
    }

    private static class PageManager {
        public final List<FormattedCharSequence> lines;
        public final int pageSize;
        public int currentPage;

        public PageManager(List<FormattedCharSequence> lines, int pageSize) {
            this.lines = lines;
            this.pageSize = pageSize;
        }

        public void scroll(int delta) {
            this.currentPage += delta;
            int totalPages = (this.lines.size() - 1) / this.pageSize + 1;
            if (this.currentPage < 0) {
                this.currentPage = totalPages - 1;
            }
            if (this.currentPage >= totalPages) {
                this.currentPage = 0;
            }
        }

        public int start() {
            return this.currentPage * this.pageSize;
        }
    }
}

