/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.oldcreatestuff.FurnaceEngineInteractions;
import com.teammoeg.steampowered.oldcreatestuff.OldEngineBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldEngineBlockEntity;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlockEntity;
import com.teammoeg.steampowered.registrate.SPBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnaceEngineTileEntity
extends OldEngineBlockEntity {
    public FurnaceEngineTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void lazyTick() {
        this.updateFurnace();
        super.lazyTick();
    }

    public void updateFurnace() {
        float capacity;
        BlockState state = this.f_58857_.m_8055_(OldEngineBlock.getBaseBlockPos(this.m_58900_(), this.f_58858_));
        FurnaceEngineInteractions.InteractionHandler handler = FurnaceEngineInteractions.getHandler(state);
        FurnaceEngineInteractions.HeatSource heatSource = handler.getHeatSource(state);
        if (heatSource.isEmpty()) {
            return;
        }
        float modifier = handler.getSpeedModifier(state);
        boolean active = heatSource.isActive();
        float speed = active ? (float)((Integer)SPConfig.COMMON.brassFlywheelSpeed.get()).intValue() * modifier : 0.0f;
        this.appliedCapacity = capacity = (float)(active ? (Integer)SPConfig.COMMON.brassFlywheelCapacity.get() : 0);
        this.appliedSpeed = speed;
        this.refreshWheelSpeed();
    }

    @Override
    public void attachWheel() {
        Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)OldEngineBlock.f_54117_);
        BlockPos wheelPos = this.f_58858_.m_5484_(engineFacing, 2);
        BlockState wheelState = this.f_58857_.m_8055_(wheelPos);
        if (!SPBlocks.BRASS_FLYWHEEL.has(wheelState)) {
            return;
        }
        Direction wheelFacing = (Direction)wheelState.m_61143_(OldFlywheelBlock.HORIZONTAL_FACING);
        if (wheelFacing.m_122434_() != engineFacing.m_122427_().m_122434_()) {
            return;
        }
        if (OldFlywheelBlock.isConnected(wheelState) && OldFlywheelBlock.getConnection(wheelState) != engineFacing.m_122424_()) {
            return;
        }
        BlockEntity te = this.f_58857_.m_7702_(wheelPos);
        if (te.m_58901_()) {
            return;
        }
        if (te instanceof OldFlywheelBlockEntity) {
            if (!OldFlywheelBlock.isConnected(wheelState)) {
                OldFlywheelBlock.setConnection(this.f_58857_, te.m_58899_(), te.m_58900_(), engineFacing.m_122424_());
            }
            this.poweredWheel = (OldFlywheelBlockEntity)te;
            this.refreshWheelSpeed();
        }
    }
}

