/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.simibubi.create.AllShapes;
import com.simibubi.create.foundation.block.IBE;
import com.teammoeg.steampowered.block.SPBlockPartials;
import com.teammoeg.steampowered.content.engine.FurnaceEngineTileEntity;
import com.teammoeg.steampowered.oldcreatestuff.FurnaceEngineInteractions;
import com.teammoeg.steampowered.oldcreatestuff.OldEngineBlock;
import com.teammoeg.steampowered.registrate.SPBlockEntities;
import com.teammoeg.steampowered.registrate.SPBlocks;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.levelWrappers.WrappedLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FurnaceEngineBlock
extends OldEngineBlock
implements IBE<FurnaceEngineTileEntity> {
    public FurnaceEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected boolean isValidBaseBlock(BlockState baseBlock, BlockGetter world, BlockPos pos) {
        return FurnaceEngineInteractions.getHandler(baseBlock).getHeatSource(baseBlock).isValid();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.FURNACE_ENGINE.get((Direction)state.m_61143_((Property)f_54117_));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getFrameModel() {
        return SPBlockPartials.FURNACE_GENERATOR_FRAME;
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (worldIn instanceof WrappedLevel) {
            return;
        }
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)FurnaceEngineBlock.getBaseBlockPos(state, pos)) && this.m_7898_(state, (LevelReader)worldIn, pos)) {
            this.withBlockEntityDo((BlockGetter)worldIn, pos, FurnaceEngineTileEntity::updateFurnace);
        }
    }

    @SubscribeEvent
    public static void usingFurnaceEngineOnFurnacePreventsGUI(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        Item item2 = item.m_41720_();
        if (!(item2 instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item2;
        if (blockItem.m_40614_() != SPBlocks.FURNACE_ENGINE.get()) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (event.getFace().m_122434_().m_122478_()) {
            return;
        }
        if (state.m_60734_() instanceof AbstractFurnaceBlock) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    public Class<FurnaceEngineTileEntity> getBlockEntityClass() {
        return FurnaceEngineTileEntity.class;
    }

    public BlockEntityType<? extends FurnaceEngineTileEntity> getBlockEntityType() {
        return (BlockEntityType)SPBlockEntities.FURNACE_ENGINE.get();
    }
}

