/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.api.boiler.BoilerHeater;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.burner.BurnerBlock;
import com.teammoeg.steampowered.content.burner.IHeatReceiver;
import com.teammoeg.steampowered.registrate.SPFluids;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class BoilerTileEntity
extends SmartBlockEntity
implements IHeatReceiver,
IHaveGoggleInformation {
    FluidTank input = new FluidTank(10000, s -> s.getFluid() == Fluids.f_76193_);
    public FluidTank output = new FluidTank(10000);
    private IFluidHandler ft = new IFluidHandler(){

        public int getTanks() {
            return 2;
        }

        public FluidStack getFluidInTank(int tank) {
            switch (tank) {
                case 0: {
                    return BoilerTileEntity.this.input.getFluid();
                }
                case 1: {
                    return BoilerTileEntity.this.output.getFluid();
                }
            }
            return null;
        }

        public int getTankCapacity(int tank) {
            return 10000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && stack.getFluid() == Fluids.f_76193_;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int filled = BoilerTileEntity.this.input.fill(resource, action);
            if (filled > 0 && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.m_6596_();
                BoilerTileEntity.this.f_58857_.m_7260_(BoilerTileEntity.this.m_58899_(), BoilerTileEntity.this.m_58900_(), BoilerTileEntity.this.m_58900_(), 3);
            }
            return filled;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack drained = BoilerTileEntity.this.output.drain(resource, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.m_6596_();
                BoilerTileEntity.this.f_58857_.m_7260_(BoilerTileEntity.this.m_58899_(), BoilerTileEntity.this.m_58900_(), BoilerTileEntity.this.m_58900_(), 3);
            }
            return drained;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = BoilerTileEntity.this.output.drain(maxDrain, action);
            if (!drained.isEmpty() && action == IFluidHandler.FluidAction.EXECUTE) {
                BoilerTileEntity.this.m_6596_();
                BoilerTileEntity.this.f_58857_.m_7260_(BoilerTileEntity.this.m_58899_(), BoilerTileEntity.this.m_58900_(), BoilerTileEntity.this.m_58900_(), 3);
            }
            return drained;
        }
    };
    int heatreceived;
    int lastheat;
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.ft);
    private int particleInterval = 0;

    public BoilerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("in", (Tag)this.input.writeToNBT(new CompoundTag()));
        nbt.m_128365_("out", (Tag)this.output.writeToNBT(new CompoundTag()));
        nbt.m_128405_("hu", this.heatreceived);
        nbt.m_128405_("lasthu", this.lastheat);
        super.write(nbt, clientPacket);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.input.readFromNBT(nbt.m_128469_("in"));
        this.output.readFromNBT(nbt.m_128469_("out"));
        this.heatreceived = nbt.m_128451_("hu");
        this.lastheat = nbt.m_128451_("lasthu");
        super.read(nbt, clientPacket);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.getHeatFromHeater();
            this.lastheat = this.heatreceived;
            if (this.heatreceived != 0) {
                int consume = Math.min(this.getHUPerTick(), this.heatreceived);
                this.heatreceived = 0;
                double waterconsume = (Double)SPConfig.COMMON.steamPerWater.get() * 10.0;
                consume = Math.min((int)((double)this.input.drain((int)Math.ceil((double)consume / waterconsume), IFluidHandler.FluidAction.EXECUTE).getAmount() * waterconsume), consume);
                this.output.fill(new FluidStack((Fluid)SPFluids.STEAM.get(), consume / 10), IFluidHandler.FluidAction.EXECUTE);
                if (consume > 0) {
                    this.m_6596_();
                    this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                }
            }
        } else if (this.output.getFluidAmount() >= this.output.getCapacity() && this.lastheat != 0) {
            ++this.particleInterval;
            if (this.particleInterval >= 20) {
                this.particleInterval = 0;
                double d0 = this.f_58858_.m_123341_();
                double d1 = this.f_58858_.m_123342_() + 1;
                double d2 = this.f_58858_.m_123343_();
                this.f_58857_.m_7785_(d0, d1, d2, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.25f, 0.25f, false);
                for (int i = 0; i < this.f_58857_.f_46441_.m_188503_(3) + 1; ++i) {
                    this.f_58857_.m_7106_((ParticleOptions)Particles.STEAM.get(), d0 + (double)this.f_58857_.f_46441_.m_188501_(), d1, d2 + (double)this.f_58857_.f_46441_.m_188501_(), 0.0, 0.0, 0.0);
                }
            }
        } else {
            this.particleInterval = 0;
        }
    }

    @Override
    public void commitHeat(float value) {
        this.heatreceived = (int)value;
    }

    protected void getHeatFromHeater() {
        BlockPos below = this.m_58899_().m_7495_();
        BlockState belowState = this.f_58857_.m_8055_(below);
        if (belowState.m_60734_() instanceof BurnerBlock) {
            return;
        }
        float heat = BoilerHeater.findHeat((Level)this.f_58857_, (BlockPos)below, (BlockState)belowState);
        if (heat > 0.0f) {
            this.commitHeat(Math.max(heat, 3.0f) * (float)this.getHUPerTick() * 0.75f);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.input));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.output));
        return true;
    }

    protected abstract int getHUPerTick();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return cap == ForgeCapabilities.FLUID_HANDLER ? this.holder.cast() : super.getCapability(cap, side);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.ft);
        oldCap.invalidate();
    }
}

