/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.teammoeg.steampowered.block.SPBlockPartials;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlockEntity;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class AbstractSPFlywheelRenderer
extends KineticBlockEntityRenderer<OldFlywheelBlockEntity> {
    public AbstractSPFlywheelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(OldFlywheelBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        if (!VisualizationManager.supportsVisualization((LevelAccessor)te.m_58904_())) {
            BlockState blockState = te.m_58900_();
            OldFlywheelBlockEntity wte = te;
            float speed = wte.visualSpeed.get(partialTicks) * 3.0f / 10.0f;
            float angle = wte.angle + speed * partialTicks;
            VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
            if (OldFlywheelBlock.isConnected(blockState)) {
                Direction connection = OldFlywheelBlock.getConnection(blockState);
                light = LevelRenderer.m_109537_((BlockAndTintGetter)te.m_58904_(), (BlockState)blockState, (BlockPos)te.m_58899_().m_121945_(connection));
                float rotation = connection.m_122434_() == Direction.Axis.X ^ connection.m_122421_() == Direction.AxisDirection.NEGATIVE ? -angle : angle;
                boolean flip = blockState.m_61143_(OldFlywheelBlock.CONNECTION) == OldFlywheelBlock.ConnectionState.LEFT;
                this.transformConnector(this.rotateToFacing(CachedBuffers.partial((PartialModel)SPBlockPartials.BRONZE_FLYWHEEL_UPPER_ROTATING, (BlockState)blockState), connection), true, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBuffers.partial((PartialModel)SPBlockPartials.BRONZE_FLYWHEEL_LOWER_ROTATING, (BlockState)blockState), connection), false, true, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBuffers.partial((PartialModel)SPBlockPartials.BRONZE_FLYWHEEL_UPPER_SLIDING, (BlockState)blockState), connection), true, false, rotation, flip).light(light).renderInto(ms, vb);
                this.transformConnector(this.rotateToFacing(CachedBuffers.partial((PartialModel)SPBlockPartials.BRONZE_FLYWHEEL_LOWER_SLIDING, (BlockState)blockState), connection), false, false, rotation, flip).light(light).renderInto(ms, vb);
            }
            this.renderFlywheel((KineticBlockEntity)te, ms, light, blockState, angle, vb);
        }
    }

    private void renderFlywheel(KineticBlockEntity te, PoseStack ms, int light, BlockState blockState, float angle, VertexConsumer vb) {
        BlockState referenceState = blockState.m_60717_(Rotation.CLOCKWISE_90);
        Direction facing = (Direction)referenceState.m_61143_((Property)BlockStateProperties.f_61374_);
        SuperByteBuffer wheel = CachedBuffers.partialFacing((PartialModel)SPBlockPartials.BRONZE_FLYWHEEL, (BlockState)referenceState, (Direction)facing);
        AbstractSPFlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)te, (Direction.Axis)((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_(), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity te) {
        return CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)te.m_58900_(), (Direction)((Direction)te.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = Mth.m_14031_((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = Mth.m_14179_((float)((Mth.m_14031_((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        buffer.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            buffer.rotate(Direction.Axis.X, AngleHelper.rad((double)barAngle));
        }
        buffer.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            buffer.translate(0.5625f, 0.0f, 0.0f);
        }
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, Direction facing) {
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)), Direction.Axis.Y);
        return buffer;
    }
}

