/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.client.instance;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlock;
import com.teammoeg.steampowered.oldcreatestuff.OldFlywheelBlockEntity;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSPFlywheelInstance
extends KineticBlockEntityVisual<OldFlywheelBlockEntity>
implements SimpleDynamicVisual {
    protected final Direction facing;
    protected final Direction connection;
    protected boolean connectedLeft;
    protected float connectorAngleMult;
    protected final RotatingInstance shaft;
    protected final TransformedInstance wheel;
    protected List<TransformedInstance> connectors;
    protected TransformedInstance upperRotating;
    protected TransformedInstance lowerRotating;
    protected TransformedInstance upperSliding;
    protected TransformedInstance lowerSliding;
    protected float lastAngle = Float.NaN;

    public AbstractSPFlywheelInstance(VisualizationContext modelManager, OldFlywheelBlockEntity tile, float d) {
        super(modelManager, (KineticBlockEntity)tile, d);
        this.facing = (Direction)this.blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        this.shaft = (RotatingInstance)this.shaftModel().createInstance();
        this.shaft.setup((KineticBlockEntity)tile).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(this.facing.m_122427_()).setChanged();
        this.wheel = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getWheelModel(), (Direction)this.facing.m_122427_())).createInstance();
        this.connection = OldFlywheelBlock.getConnection(this.blockState);
        if (this.connection != null) {
            this.connectedLeft = this.blockState.m_61143_(OldFlywheelBlock.CONNECTION) == OldFlywheelBlock.ConnectionState.LEFT;
            boolean flipAngle = this.connection.m_122434_() == Direction.Axis.X ^ this.connection.m_122421_() == Direction.AxisDirection.NEGATIVE;
            this.connectorAngleMult = flipAngle ? -1.0f : 1.0f;
            this.upperRotating = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getUpperRotatingModel())).createInstance();
            this.lowerRotating = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getLowerRotatingModel())).createInstance();
            this.upperSliding = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getUpperSlidingModel())).createInstance();
            this.lowerSliding = (TransformedInstance)this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)this.getLowerSlidingModel())).createInstance();
            this.connectors = Lists.newArrayList((Object[])new TransformedInstance[]{this.upperRotating, this.lowerRotating, this.upperSliding, this.lowerSliding});
        } else {
            this.connectors = Collections.emptyList();
        }
        this.animate(tile.angle);
    }

    public void beginFrame(DynamicVisual.Context context) {
        float partialTicks = context.partialTick();
        float speed = ((OldFlywheelBlockEntity)this.blockEntity).visualSpeed.get(partialTicks) * 3.0f / 10.0f;
        float angle = ((OldFlywheelBlockEntity)this.blockEntity).angle + speed * partialTicks;
        if ((double)Math.abs(angle - this.lastAngle) < 0.001) {
            return;
        }
        this.animate(angle);
        this.lastAngle = angle;
    }

    private void animate(float angle) {
        PoseStack ms = new PoseStack();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        msr.translate((Vec3i)this.getVisualPosition());
        if (this.connection != null) {
            float rotation = angle * this.connectorAngleMult;
            ms.m_85836_();
            this.rotateToFacing(msr, this.connection);
            ms.m_85836_();
            this.transformConnector(msr, true, true, rotation, this.connectedLeft);
            this.upperRotating.setTransform(ms);
            this.upperRotating.setChanged();
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, false, true, rotation, this.connectedLeft);
            this.lowerRotating.setTransform(ms);
            this.lowerRotating.setChanged();
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, true, false, rotation, this.connectedLeft);
            this.upperSliding.setTransform(ms);
            this.upperSliding.setChanged();
            ms.m_85849_();
            ms.m_85836_();
            this.transformConnector(msr, false, false, rotation, this.connectedLeft);
            this.lowerSliding.setTransform(ms);
            this.lowerSliding.setChanged();
            ms.m_85849_();
            ms.m_85849_();
        }
        ((PoseTransformStack)((PoseTransformStack)msr.center()).rotate(AngleHelper.rad((double)angle), Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.rotationAxis()).m_122434_())).uncenter();
        this.wheel.setTransform(ms);
        this.wheel.setChanged();
    }

    public void update(float ticks) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float v) {
        this.relight(this.pos, new FlatLit[]{this.shaft, this.wheel});
        if (this.connection != null) {
            this.relight(this.pos.m_121945_(this.connection), this.connectors.stream().map(f -> f).iterator());
        }
    }

    public void _delete() {
        this.shaft.delete();
        this.wheel.delete();
        this.connectors.forEach(AbstractInstance::delete);
        this.connectors.clear();
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    protected Instancer<RotatingInstance> shaftModel() {
        Direction opposite = this.facing.m_122424_();
        return this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF, (Direction)opposite));
    }

    protected void transformConnector(PoseTransformStack ms, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = Mth.m_14031_((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = Mth.m_14179_((float)((Mth.m_14031_((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        ms.translate(pivotX, pivotY, pivotZ + shifting);
        if (rotating) {
            ms.rotate(AngleHelper.rad((double)barAngle), Direction.Axis.X);
        }
        ms.translate(-pivotX, -pivotY, -pivotZ);
        if (flip && !upper) {
            ms.translate(0.5625f, 0.0f, 0.0f);
        }
    }

    protected void rotateToFacing(PoseTransformStack buffer, Direction facing) {
        ((PoseTransformStack)((PoseTransformStack)buffer.center()).rotate(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)), Direction.UP)).uncenter();
    }

    protected abstract PartialModel getWheelModel();

    protected abstract PartialModel getUpperSlidingModel();

    protected abstract PartialModel getLowerSlidingModel();

    protected abstract PartialModel getUpperRotatingModel();

    protected abstract PartialModel getLowerRotatingModel();
}

