/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.handler.goals.ThrowableAttackGoal;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ProjectileAttackTweak
extends BaseTweak {
    protected final ResourceLocation projectileEntityLocation;
    protected final ResourceLocation soundLocation;
    protected final int goalPriority;
    protected final float attackDamage;
    protected final float velocity;
    @Nullable
    protected final CompoundTag projectileData;

    public ProjectileAttackTweak(ResourceLocation entity, ResourceLocation projectileEntity, ResourceLocation soundLocation, int priority, float attackDamage, float velocity, String projectileData) {
        super("throwing_" + projectileEntity.m_135827_(), entity);
        this.projectileEntityLocation = projectileEntity;
        this.soundLocation = soundLocation;
        this.goalPriority = priority;
        this.attackDamage = attackDamage;
        this.velocity = velocity;
        this.projectileData = this.createNBTTag(projectileData);
    }

    public ProjectileAttackTweak(EntityType<? extends Mob> entity, EntityType<? extends Projectile> throwableType, SoundEvent soundEvent, int priority, float attackDamage, float velocity, String projectileData) {
        this(ForgeRegistries.ENTITY_TYPES.getKey(entity), ForgeRegistries.ENTITY_TYPES.getKey(throwableType), ForgeRegistries.SOUND_EVENTS.getKey((Object)soundEvent), priority, attackDamage, velocity, projectileData);
    }

    public ProjectileAttackTweak(EntityType<? extends Mob> entity, EntityType<? extends Projectile> throwableType, SoundEvent soundEvent, int priority, float attackDamage, float velocity) {
        this(entity, throwableType, soundEvent, priority, attackDamage, velocity, "");
    }

    @Override
    public void adjust(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.projectileEntityLocation);
            if (type != null) {
                Entity foundEntity = type.m_20615_(entity.m_9236_());
                if (foundEntity instanceof Projectile) {
                    Projectile throwable = (Projectile)foundEntity;
                    mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof PanicGoal);
                    mob.f_21345_.f_25345_.forEach(goal -> {
                        if (goal.m_26015_() instanceof RangedBowAttackGoal) {
                            AngryMobs.LOGGER.info(String.format("Removing existing AI to apply the AI tweak of ID %s for entity %s", this.getEntityLocation(), this.getName()));
                        }
                    });
                    mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof RangedBowAttackGoal);
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.soundLocation);
                    mob.f_21346_.m_25352_(this.goalPriority, (Goal)new ThrowableAttackGoal(mob, (EntityType<? extends Projectile>)throwable.m_6095_(), () -> sound, this.attackDamage, this.velocity, this.projectileData));
                    foundEntity.m_146870_();
                } else {
                    AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Projectile entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
                }
            } else {
                AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Projectile entity could not be found", this.getName(), this.getEntityLocation()));
            }
        } else {
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
        }
    }

    public CompoundTag createNBTTag(String nbtData) {
        if (nbtData.isEmpty()) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        try {
            tag = nbtData.startsWith("{") && nbtData.endsWith("}") ? TagParser.m_129359_((String)nbtData) : TagParser.m_129359_((String)("{" + nbtData + "}"));
        }
        catch (CommandSyntaxException exception) {
            AngryMobs.LOGGER.error("Error parsing NBT data for projectile attack tweak: {}", (Object)exception.getMessage());
        }
        return tag;
    }
}

