/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.handler.goals.MobMeleeAttackGoal;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraftforge.registries.ForgeRegistries;

public class MeleeAttackTweak
extends BaseTweak {
    protected final int goalPriority;
    protected final double speedIn;
    protected final float damage;
    protected final float knockback;
    protected final boolean useLongMemory;

    public MeleeAttackTweak(ResourceLocation entity, int priority, double speedIn, float damage, float knockback, boolean useLongMemory) {
        super("melee_attack", entity);
        this.goalPriority = priority;
        this.speedIn = speedIn;
        this.damage = damage;
        this.knockback = knockback;
        this.useLongMemory = useLongMemory;
    }

    public MeleeAttackTweak(EntityType<? extends Mob> entity, int priority, double speedIn, float damage, float knockback, boolean useLongMemory) {
        this(ForgeRegistries.ENTITY_TYPES.getKey(entity), priority, speedIn, damage, knockback, useLongMemory);
    }

    public MeleeAttackTweak(EntityType<? extends Mob> entity, int priority, double speedIn, float damage, boolean useLongMemory) {
        this(ForgeRegistries.ENTITY_TYPES.getKey(entity), priority, speedIn, damage, 0.0f, useLongMemory);
    }

    @Override
    public void adjust(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof PanicGoal);
            mob.f_21345_.f_25345_.forEach(goal -> {
                if (goal.m_26015_() instanceof MeleeAttackGoal) {
                    AngryMobs.LOGGER.info(String.format("Removing existing AI to apply the AI tweak of ID %s for entity %s", this.getEntityLocation(), this.getName()));
                }
            });
            mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof MeleeAttackGoal);
            mob.f_21345_.m_25352_(this.goalPriority, (Goal)new MobMeleeAttackGoal(mob, this.speedIn, this.damage, this.knockback, this.useLongMemory));
        } else {
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
        }
    }
}

