/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class LookAtEntityTweak
extends BaseTweak {
    protected final ResourceLocation targetEntityLocation;
    protected final int goalPriority;
    protected final float lookDistance;

    public LookAtEntityTweak(ResourceLocation entity, ResourceLocation target, int priority, float lookDistance) {
        super("look_at_" + target.m_135827_(), entity);
        this.targetEntityLocation = target;
        this.goalPriority = priority;
        this.lookDistance = lookDistance;
    }

    @Override
    public void adjust(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (this.canHaveGoal(mob)) {
                if (this.targetEntityLocation.toString().equals("minecraft:player")) {
                    mob.f_21346_.m_25352_(this.goalPriority, (Goal)new LookAtPlayerGoal(mob, Player.class, this.lookDistance));
                } else {
                    Entity targetEntity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.targetEntityLocation)).m_20615_(entity.m_9236_());
                    if (targetEntity instanceof LivingEntity) {
                        Class<?> entityClass = ((LivingEntity)targetEntity).getClass();
                        mob.f_21346_.m_25352_(this.goalPriority, (Goal)new LookAtPlayerGoal(mob, entityClass, this.lookDistance));
                        targetEntity.m_146870_();
                    } else {
                        AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Target entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
                    }
                }
            }
        } else {
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
        }
    }

    public boolean canHaveGoal(Mob mob) {
        for (Goal goal : mob.f_21345_.f_25345_) {
            Class<?> entityClass;
            if (!(goal instanceof LookAtPlayerGoal)) continue;
            LookAtPlayerGoal lookAtPlayerGoal = (LookAtPlayerGoal)goal;
            if (this.targetEntityLocation.toString().equals("minecraft:player")) {
                if (lookAtPlayerGoal.f_25516_ != Player.class) continue;
                AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity already has given AI goal", this.getName(), this.getEntityLocation()));
                return false;
            }
            Entity targetEntity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.targetEntityLocation)).m_20615_(mob.m_9236_());
            if (!(targetEntity instanceof LivingEntity) || lookAtPlayerGoal.f_25516_ != (entityClass = ((LivingEntity)targetEntity).getClass())) continue;
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity already has given AI goal", this.getName(), this.getEntityLocation()));
            targetEntity.m_146870_();
            return false;
        }
        return true;
    }
}

