/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraftforge.registries.ForgeRegistries;

public class LeapAtTargetTweak
extends BaseTweak {
    protected final int goalPriority;
    protected final float leapMotion;

    public LeapAtTargetTweak(ResourceLocation entity, int priority, float leapMotion) {
        super("leap_at_target", entity);
        this.goalPriority = priority;
        this.leapMotion = leapMotion;
    }

    public LeapAtTargetTweak(EntityType<? extends PathfinderMob> entity, int priority, float leapMotion) {
        this(ForgeRegistries.ENTITY_TYPES.getKey(entity), priority, leapMotion);
    }

    @Override
    public void adjust(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_21345_.f_25345_.forEach(goal -> {
                if (goal.m_26015_() instanceof LeapAtTargetGoal) {
                    AngryMobs.LOGGER.info(String.format("Overriding existing AI goal for entity %s using tweak ID %s", this.getEntityLocation(), this.getName()));
                }
            });
            mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof LeapAtTargetGoal);
            mob.f_21345_.m_25352_(this.goalPriority, (Goal)new LeapAtTargetGoal(mob, this.leapMotion));
        } else {
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
        }
    }
}

