/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraftforge.registries.ForgeRegistries;

public class BreakDoorTweak
extends BaseTweak {
    protected final int goalPriority;
    protected final Difficulty difficulty;

    public BreakDoorTweak(ResourceLocation entity, int priority, int difficulty) {
        super("break_door", entity);
        this.goalPriority = priority;
        this.difficulty = Difficulty.m_19029_((int)difficulty);
    }

    public BreakDoorTweak(EntityType<? extends Mob> entity, int priority, int difficulty) {
        this(ForgeRegistries.ENTITY_TYPES.getKey(entity), priority, difficulty);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void adjust(Entity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (this.difficulty != null) {
                mob.f_21345_.f_25345_.forEach(goal -> {
                    if (goal.m_26015_() instanceof BreakDoorGoal) {
                        AngryMobs.LOGGER.info(String.format("Overriding existing AI goal for entity %s using tweak ID %s", this.getEntityLocation(), this.getName()));
                    }
                });
                mob.f_21345_.f_25345_.removeIf(goal -> goal.m_26015_() instanceof BreakDoorGoal);
                Predicate<Difficulty> DOOR_BREAKING_PREDICATE = dif -> dif == this.difficulty;
                mob.f_21345_.m_25352_(this.goalPriority, (Goal)new BreakDoorGoal(mob, DOOR_BREAKING_PREDICATE));
                return;
            }
        }
        AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
    }
}

