/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry.tweaks;

import com.mrbysco.angrymobs.AngryMobs;
import com.mrbysco.angrymobs.registry.tweaks.BaseTweak;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class AvoidEntityTweak
extends BaseTweak {
    protected final ResourceLocation targetEntityLocation;
    protected final int goalPriority;
    protected final float maxDistance;
    protected final double walkSpeedModifier;
    protected final double sprintSpeedModifier;

    public AvoidEntityTweak(ResourceLocation entity, ResourceLocation target, int priority, float maxDistance, double walkSpeedModifier, double sprintSpeedModifier) {
        super("avoid_entity_" + target.m_135827_(), entity);
        this.targetEntityLocation = target;
        this.goalPriority = priority;
        this.maxDistance = maxDistance;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
    }

    @Override
    public void adjust(Entity entity) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            if (this.canHaveGoal(pathfinderMob)) {
                if (this.targetEntityLocation.toString().equals("minecraft:player")) {
                    pathfinderMob.f_21346_.m_25352_(this.goalPriority, (Goal)new AvoidEntityGoal(pathfinderMob, Player.class, this.maxDistance, this.walkSpeedModifier, this.sprintSpeedModifier));
                } else {
                    Entity targetEntity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.targetEntityLocation)).m_20615_(entity.m_9236_());
                    if (targetEntity instanceof LivingEntity) {
                        Class<?> entityClass = ((LivingEntity)targetEntity).getClass();
                        pathfinderMob.f_21346_.m_25352_(this.goalPriority, (Goal)new AvoidEntityGoal(pathfinderMob, entityClass, this.maxDistance, this.walkSpeedModifier, this.sprintSpeedModifier));
                        targetEntity.m_146870_();
                    } else {
                        AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Target entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
                    }
                }
            }
        } else {
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity isn't valid for the tweak", this.getName(), this.getEntityLocation()));
        }
    }

    public boolean canHaveGoal(PathfinderMob pathfinderMob) {
        for (Goal goal : pathfinderMob.f_21345_.f_25345_) {
            Class<?> entityClass;
            if (!(goal instanceof AvoidEntityGoal)) continue;
            AvoidEntityGoal avoidEntity = (AvoidEntityGoal)goal;
            if (this.targetEntityLocation.toString().equals("minecraft:player")) {
                if (avoidEntity.f_25020_ != Player.class) continue;
                AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity already has given AI goal", this.getName(), this.getEntityLocation()));
                return false;
            }
            Entity targetEntity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.targetEntityLocation)).m_20615_(pathfinderMob.m_9236_());
            if (!(targetEntity instanceof LivingEntity) || avoidEntity.f_25020_ != (entityClass = ((LivingEntity)targetEntity).getClass())) continue;
            AngryMobs.LOGGER.error(String.format("Can't apply AI tweak of ID %s for entity %s. Entity already has given AI goal", this.getName(), this.getEntityLocation()));
            targetEntity.m_146870_();
            return false;
        }
        return true;
    }
}

