/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.registry;

import com.mrbysco.angrymobs.config.AngryConfig;
import com.mrbysco.angrymobs.registry.tweaks.AttackNearestTweak;
import com.mrbysco.angrymobs.registry.tweaks.HurtByTargetTweak;
import com.mrbysco.angrymobs.registry.tweaks.ITweak;
import com.mrbysco.angrymobs.registry.tweaks.LeapAtTargetTweak;
import com.mrbysco.angrymobs.registry.tweaks.MeleeAttackTweak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraftforge.registries.ForgeRegistries;

public class AITweakRegistry {
    private final LinkedHashMap<ResourceLocation, List<ITweak>> tweakMap = new LinkedHashMap();
    private static AITweakRegistry INSTANCE;

    public static AITweakRegistry instance() {
        if (INSTANCE == null) {
            INSTANCE = new AITweakRegistry();
        }
        return INSTANCE;
    }

    public void initializeTweaks() {
        this.tweakMap.clear();
        if (((Boolean)AngryConfig.COMMON.angryAnimals.get()).booleanValue() || ((Boolean)AngryConfig.COMMON.aggressiveAnimals.get()).booleanValue()) {
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20555_, 1, 0.95, 1.0f, false));
            this.registerTweak(new LeapAtTargetTweak((EntityType<? extends PathfinderMob>)EntityType.f_20555_, 4, 0.3f));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20557_, 1, 1.0, 2.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20560_, 1, 1.5, 3.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20457_, 1, 1.5, 3.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20504_, 1, 1.0, 2.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20503_, 1, 1.5, 3.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20510_, 1, 1.0, 2.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20517_, 1, 1.4, 1.0f, false));
            this.registerTweak(new MeleeAttackTweak((EntityType<? extends Mob>)EntityType.f_20520_, 1, 1.0, 2.0f, false));
            if (((Boolean)AngryConfig.COMMON.angryAnimals.get()).booleanValue()) {
                boolean reinforcements = (Boolean)AngryConfig.COMMON.angryReinforcements.get();
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20555_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20557_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20560_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20457_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20504_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20503_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20510_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20517_, 1, reinforcements, true));
                this.registerTweak(new HurtByTargetTweak((EntityType<? extends Mob>)EntityType.f_20520_, 1, reinforcements, true));
            }
            if (((Boolean)AngryConfig.COMMON.aggressiveAnimals.get()).booleanValue()) {
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20553_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20555_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20557_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20560_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20452_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20457_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20466_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20503_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20507_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20510_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20520_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20488_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
                this.registerTweak(new AttackNearestTweak((EntityType<? extends Mob>)EntityType.f_20499_, (EntityType<? extends LivingEntity>)EntityType.f_20532_, 2, true));
            }
        }
    }

    public void registerTweak(ITweak event) {
        ResourceLocation entityLocation = event.getEntityLocation();
        if (this.tweakMap.containsKey(entityLocation)) {
            ArrayList<ITweak> dataList = new ArrayList<ITweak>((Collection)this.tweakMap.get(entityLocation));
            dataList.add(event);
            this.tweakMap.put(entityLocation, dataList);
        } else {
            this.tweakMap.put(entityLocation, Collections.singletonList(event));
        }
    }

    public boolean containsEntity(EntityType<? extends PathfinderMob> entityType) {
        return this.tweakMap.containsKey(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
    }

    public boolean containsEntity(ResourceLocation entityLocation) {
        return this.tweakMap.containsKey(entityLocation);
    }

    public List<ITweak> getTweaksFromType(EntityType<? extends PathfinderMob> entityType) {
        return this.tweakMap.containsKey(ForgeRegistries.ENTITY_TYPES.getKey(entityType)) ? this.tweakMap.get(ForgeRegistries.ENTITY_TYPES.getKey(entityType)) : new ArrayList<ITweak>();
    }

    public List<ITweak> getTweaksFromType(ResourceLocation entityLocation) {
        return this.tweakMap.containsKey(entityLocation) ? this.tweakMap.get(entityLocation) : new ArrayList<ITweak>();
    }

    public LinkedHashMap<ResourceLocation, List<ITweak>> getTweakMap() {
        return this.tweakMap;
    }
}

