/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.angrymobs.handler.goals;

import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import org.jetbrains.annotations.Nullable;

public class ThrowableAttackGoal
extends Goal {
    private final Mob mob;
    private int attackStep;
    private int attackTime;
    private int firedRecentlyTimer;
    private final EntityType<? extends Projectile> projectile;
    private final float ATTACK_DAMAGE;
    private final float velocity;
    private final Supplier<SoundEvent> soundEventSupplier;
    @Nullable
    private final CompoundTag projectileData;

    public ThrowableAttackGoal(Mob mobEntity, EntityType<? extends Projectile> projectileType, Supplier<SoundEvent> soundEventSupplier, float attackDamage, float projectileVelocity, @Nullable CompoundTag projectileData) {
        this.mob = mobEntity;
        this.projectile = projectileType;
        this.soundEventSupplier = soundEventSupplier;
        this.ATTACK_DAMAGE = attackDamage;
        this.velocity = projectileVelocity;
        this.projectileData = projectileData;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        return livingentity != null && livingentity.m_6084_() && this.mob.m_6779_(livingentity);
    }

    public void m_8056_() {
        this.attackStep = 0;
    }

    public void m_8041_() {
        this.firedRecentlyTimer = 0;
    }

    public void m_8037_() {
        --this.attackTime;
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean flag = this.mob.m_21574_().m_148306_((Entity)livingentity);
            this.firedRecentlyTimer = flag ? 0 : ++this.firedRecentlyTimer;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            if (d0 < 4.0) {
                if (!flag) {
                    return;
                }
                if (this.attackTime <= 0) {
                    this.attackTime = 20;
                    livingentity.m_6469_(livingentity.m_269291_().m_269333_((LivingEntity)this.mob), this.ATTACK_DAMAGE);
                }
                this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
            } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                if (this.attackTime <= 0) {
                    Projectile projectileEntity;
                    this.attackTime = 100;
                    if (this.soundEventSupplier.get() != null && !this.mob.m_20067_()) {
                        this.mob.m_5496_(this.soundEventSupplier.get(), 1.0f, 1.0f + (this.mob.m_217043_().m_188501_() - this.mob.m_217043_().m_188501_()) * 0.4f);
                    }
                    if ((projectileEntity = (Projectile)this.projectile.m_20615_(this.mob.m_9236_())) != null) {
                        projectileEntity.m_5602_((Entity)this.mob);
                        projectileEntity.m_146922_(this.mob.m_146908_() % 360.0f);
                        projectileEntity.m_146926_(this.mob.m_146909_() % 360.0f);
                        projectileEntity.m_7678_(this.mob.m_20185_(), this.mob.m_20188_() - (double)0.1f, this.mob.m_20189_(), this.mob.m_146908_(), this.mob.m_146909_());
                        this.mergeData(projectileEntity);
                        double projX = livingentity.m_20185_() - this.mob.m_20185_();
                        double projY = livingentity.m_20227_(0.3333333333333333) - projectileEntity.m_20186_();
                        double projZ = livingentity.m_20189_() - this.mob.m_20189_();
                        double projD3 = Math.sqrt(projX * projX + projZ * projZ);
                        projectileEntity.m_6686_(projX, projY + projD3 * (double)0.2f, projZ, this.velocity, (float)(14 - this.mob.m_9236_().m_46791_().m_19028_() * 4));
                        this.mob.m_9236_().m_7967_((Entity)projectileEntity);
                    }
                }
                this.mob.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
            } else if (this.firedRecentlyTimer < 5) {
                this.mob.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
            }
            super.m_8037_();
        }
    }

    private void mergeData(Projectile projectile) {
        if (this.projectileData == null) {
            return;
        }
        CompoundTag entityTag = projectile.m_20240_(new CompoundTag());
        CompoundTag entityTagCopy = entityTag.m_6426_();
        if (!this.projectileData.m_128456_()) {
            entityTagCopy.m_128391_(this.projectileData);
            UUID uuid = projectile.m_20148_();
            projectile.m_20258_(entityTagCopy);
            projectile.m_20084_(uuid);
        }
    }

    private double getFollowDistance() {
        return this.mob.m_21133_(Attributes.f_22277_);
    }
}

